package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkDataBuilder extends NetworkDataFluent<NetworkDataBuilder> implements VisitableBuilder<NetworkData,NetworkDataBuilder>{
  public NetworkDataBuilder() {
    this(new NetworkData());
  }
  
  public NetworkDataBuilder(NetworkDataFluent<?> fluent) {
    this(fluent, new NetworkData());
  }
  
  public NetworkDataBuilder(NetworkDataFluent<?> fluent,NetworkData instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkDataBuilder(NetworkData instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkDataFluent<?> fluent;
  
  public NetworkData build() {
    NetworkData buildable = new NetworkData(fluent.buildLinks(),fluent.buildNetworks(),fluent.buildServices());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}