package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDataLinkBondFluent<A extends NetworkDataLinkBondFluent<A>> extends BaseFluent<A>{
  public NetworkDataLinkBondFluent() {
  }
  
  public NetworkDataLinkBondFluent(NetworkDataLinkBond instance) {
    this.copyInstance(instance);
  }
  private List<String> bondLinks = new ArrayList<String>();
  private String bondMode;
  private String bondXmitHashPolicy;
  private String id;
  private NetworkLinkEthernetMacBuilder macAddress;
  private Integer mtu;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkDataLinkBond instance) {
    instance = (instance != null ? instance : new NetworkDataLinkBond());
    if (instance != null) {
          this.withBondLinks(instance.getBondLinks());
          this.withBondMode(instance.getBondMode());
          this.withBondXmitHashPolicy(instance.getBondXmitHashPolicy());
          this.withId(instance.getId());
          this.withMacAddress(instance.getMacAddress());
          this.withMtu(instance.getMtu());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToBondLinks(int index,String item) {
    if (this.bondLinks == null) {this.bondLinks = new ArrayList<String>();}
    this.bondLinks.add(index, item);
    return (A)this;
  }
  
  public A setToBondLinks(int index,String item) {
    if (this.bondLinks == null) {this.bondLinks = new ArrayList<String>();}
    this.bondLinks.set(index, item); return (A)this;
  }
  
  public A addToBondLinks(java.lang.String... items) {
    if (this.bondLinks == null) {this.bondLinks = new ArrayList<String>();}
    for (String item : items) {this.bondLinks.add(item);} return (A)this;
  }
  
  public A addAllToBondLinks(Collection<String> items) {
    if (this.bondLinks == null) {this.bondLinks = new ArrayList<String>();}
    for (String item : items) {this.bondLinks.add(item);} return (A)this;
  }
  
  public A removeFromBondLinks(java.lang.String... items) {
    if (this.bondLinks == null) return (A)this;
    for (String item : items) { this.bondLinks.remove(item);} return (A)this;
  }
  
  public A removeAllFromBondLinks(Collection<String> items) {
    if (this.bondLinks == null) return (A)this;
    for (String item : items) { this.bondLinks.remove(item);} return (A)this;
  }
  
  public List<String> getBondLinks() {
    return this.bondLinks;
  }
  
  public String getBondLink(int index) {
    return this.bondLinks.get(index);
  }
  
  public String getFirstBondLink() {
    return this.bondLinks.get(0);
  }
  
  public String getLastBondLink() {
    return this.bondLinks.get(bondLinks.size() - 1);
  }
  
  public String getMatchingBondLink(Predicate<String> predicate) {
      for (String item : bondLinks) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingBondLink(Predicate<String> predicate) {
      for (String item : bondLinks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBondLinks(List<String> bondLinks) {
    if (bondLinks != null) {
        this.bondLinks = new ArrayList();
        for (String item : bondLinks) {
          this.addToBondLinks(item);
        }
    } else {
      this.bondLinks = null;
    }
    return (A) this;
  }
  
  public A withBondLinks(java.lang.String... bondLinks) {
    if (this.bondLinks != null) {
        this.bondLinks.clear();
        _visitables.remove("bondLinks");
    }
    if (bondLinks != null) {
      for (String item : bondLinks) {
        this.addToBondLinks(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBondLinks() {
    return this.bondLinks != null && !this.bondLinks.isEmpty();
  }
  
  public String getBondMode() {
    return this.bondMode;
  }
  
  public A withBondMode(String bondMode) {
    this.bondMode = bondMode;
    return (A) this;
  }
  
  public boolean hasBondMode() {
    return this.bondMode != null;
  }
  
  public String getBondXmitHashPolicy() {
    return this.bondXmitHashPolicy;
  }
  
  public A withBondXmitHashPolicy(String bondXmitHashPolicy) {
    this.bondXmitHashPolicy = bondXmitHashPolicy;
    return (A) this;
  }
  
  public boolean hasBondXmitHashPolicy() {
    return this.bondXmitHashPolicy != null;
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public NetworkLinkEthernetMac buildMacAddress() {
    return this.macAddress != null ? this.macAddress.build() : null;
  }
  
  public A withMacAddress(NetworkLinkEthernetMac macAddress) {
    this._visitables.remove("macAddress");
    if (macAddress != null) {
        this.macAddress = new NetworkLinkEthernetMacBuilder(macAddress);
        this._visitables.get("macAddress").add(this.macAddress);
    } else {
        this.macAddress = null;
        this._visitables.get("macAddress").remove(this.macAddress);
    }
    return (A) this;
  }
  
  public boolean hasMacAddress() {
    return this.macAddress != null;
  }
  
  public MacAddressNested<A> withNewMacAddress() {
    return new MacAddressNested(null);
  }
  
  public MacAddressNested<A> withNewMacAddressLike(NetworkLinkEthernetMac item) {
    return new MacAddressNested(item);
  }
  
  public MacAddressNested<A> editMacAddress() {
    return withNewMacAddressLike(java.util.Optional.ofNullable(buildMacAddress()).orElse(null));
  }
  
  public MacAddressNested<A> editOrNewMacAddress() {
    return withNewMacAddressLike(java.util.Optional.ofNullable(buildMacAddress()).orElse(new NetworkLinkEthernetMacBuilder().build()));
  }
  
  public MacAddressNested<A> editOrNewMacAddressLike(NetworkLinkEthernetMac item) {
    return withNewMacAddressLike(java.util.Optional.ofNullable(buildMacAddress()).orElse(item));
  }
  
  public Integer getMtu() {
    return this.mtu;
  }
  
  public A withMtu(Integer mtu) {
    this.mtu = mtu;
    return (A) this;
  }
  
  public boolean hasMtu() {
    return this.mtu != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDataLinkBondFluent that = (NetworkDataLinkBondFluent) o;
    if (!java.util.Objects.equals(bondLinks, that.bondLinks)) return false;
    if (!java.util.Objects.equals(bondMode, that.bondMode)) return false;
    if (!java.util.Objects.equals(bondXmitHashPolicy, that.bondXmitHashPolicy)) return false;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(macAddress, that.macAddress)) return false;
    if (!java.util.Objects.equals(mtu, that.mtu)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bondLinks,  bondMode,  bondXmitHashPolicy,  id,  macAddress,  mtu,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bondLinks != null && !bondLinks.isEmpty()) { sb.append("bondLinks:"); sb.append(bondLinks + ","); }
    if (bondMode != null) { sb.append("bondMode:"); sb.append(bondMode + ","); }
    if (bondXmitHashPolicy != null) { sb.append("bondXmitHashPolicy:"); sb.append(bondXmitHashPolicy + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (macAddress != null) { sb.append("macAddress:"); sb.append(macAddress + ","); }
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MacAddressNested<N> extends NetworkLinkEthernetMacFluent<MacAddressNested<N>> implements Nested<N>{
    MacAddressNested(NetworkLinkEthernetMac item) {
      this.builder = new NetworkLinkEthernetMacBuilder(this, item);
    }
    NetworkLinkEthernetMacBuilder builder;
    
    public N and() {
      return (N) NetworkDataLinkBondFluent.this.withMacAddress(builder.build());
    }
    
    public N endMacAddress() {
      return and();
    }
    
  
  }

}