package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureProviderSpecBuilder extends AzureProviderSpecFluent<AzureProviderSpecBuilder> implements VisitableBuilder<AzureProviderSpec,AzureProviderSpecBuilder>{
  public AzureProviderSpecBuilder() {
    this(new AzureProviderSpec());
  }
  
  public AzureProviderSpecBuilder(AzureProviderSpecFluent<?> fluent) {
    this(fluent, new AzureProviderSpec());
  }
  
  public AzureProviderSpecBuilder(AzureProviderSpecFluent<?> fluent,AzureProviderSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureProviderSpecBuilder(AzureProviderSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureProviderSpecFluent<?> fluent;
  
  public AzureProviderSpec build() {
    AzureProviderSpec buildable = new AzureProviderSpec(fluent.getApiVersion(),fluent.getAzureClientID(),fluent.getAzureRegion(),fluent.getAzureSubscriptionID(),fluent.getAzureTenantID(),fluent.getDataPermissions(),fluent.getKind(),fluent.getPermissions(),fluent.buildRoleBindings());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}