package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GCPProviderSpecBuilder extends GCPProviderSpecFluent<GCPProviderSpecBuilder> implements VisitableBuilder<GCPProviderSpec,GCPProviderSpecBuilder>{
  public GCPProviderSpecBuilder() {
    this(new GCPProviderSpec());
  }
  
  public GCPProviderSpecBuilder(GCPProviderSpecFluent<?> fluent) {
    this(fluent, new GCPProviderSpec());
  }
  
  public GCPProviderSpecBuilder(GCPProviderSpecFluent<?> fluent,GCPProviderSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GCPProviderSpecBuilder(GCPProviderSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GCPProviderSpecFluent<?> fluent;
  
  public GCPProviderSpec build() {
    GCPProviderSpec buildable = new GCPProviderSpec(fluent.getApiVersion(),fluent.getAudience(),fluent.getKind(),fluent.getPermissions(),fluent.getPredefinedRoles(),fluent.getServiceAccountEmail(),fluent.getSkipServiceCheck());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}