package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenStackProviderSpecBuilder extends OpenStackProviderSpecFluent<OpenStackProviderSpecBuilder> implements VisitableBuilder<OpenStackProviderSpec,OpenStackProviderSpecBuilder>{
  public OpenStackProviderSpecBuilder() {
    this(new OpenStackProviderSpec());
  }
  
  public OpenStackProviderSpecBuilder(OpenStackProviderSpecFluent<?> fluent) {
    this(fluent, new OpenStackProviderSpec());
  }
  
  public OpenStackProviderSpecBuilder(OpenStackProviderSpecFluent<?> fluent,OpenStackProviderSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenStackProviderSpecBuilder(OpenStackProviderSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenStackProviderSpecFluent<?> fluent;
  
  public OpenStackProviderSpec build() {
    OpenStackProviderSpec buildable = new OpenStackProviderSpec(fluent.getApiVersion(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}