package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PciDeviceFluent<A extends PciDeviceFluent<A>> extends BaseFluent<A>{
  public PciDeviceFluent() {
  }
  
  public PciDeviceFluent(PciDevice instance) {
    this.copyInstance(instance);
  }
  private String pciAddress;
  private String pfPciAddress;
  private String rdmaDevice;
  private String representorDevice;
  private String vhostNet;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PciDevice instance) {
    instance = (instance != null ? instance : new PciDevice());
    if (instance != null) {
          this.withPciAddress(instance.getPciAddress());
          this.withPfPciAddress(instance.getPfPciAddress());
          this.withRdmaDevice(instance.getRdmaDevice());
          this.withRepresentorDevice(instance.getRepresentorDevice());
          this.withVhostNet(instance.getVhostNet());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getPciAddress() {
    return this.pciAddress;
  }
  
  public A withPciAddress(String pciAddress) {
    this.pciAddress = pciAddress;
    return (A) this;
  }
  
  public boolean hasPciAddress() {
    return this.pciAddress != null;
  }
  
  public String getPfPciAddress() {
    return this.pfPciAddress;
  }
  
  public A withPfPciAddress(String pfPciAddress) {
    this.pfPciAddress = pfPciAddress;
    return (A) this;
  }
  
  public boolean hasPfPciAddress() {
    return this.pfPciAddress != null;
  }
  
  public String getRdmaDevice() {
    return this.rdmaDevice;
  }
  
  public A withRdmaDevice(String rdmaDevice) {
    this.rdmaDevice = rdmaDevice;
    return (A) this;
  }
  
  public boolean hasRdmaDevice() {
    return this.rdmaDevice != null;
  }
  
  public String getRepresentorDevice() {
    return this.representorDevice;
  }
  
  public A withRepresentorDevice(String representorDevice) {
    this.representorDevice = representorDevice;
    return (A) this;
  }
  
  public boolean hasRepresentorDevice() {
    return this.representorDevice != null;
  }
  
  public String getVhostNet() {
    return this.vhostNet;
  }
  
  public A withVhostNet(String vhostNet) {
    this.vhostNet = vhostNet;
    return (A) this;
  }
  
  public boolean hasVhostNet() {
    return this.vhostNet != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PciDeviceFluent that = (PciDeviceFluent) o;
    if (!java.util.Objects.equals(pciAddress, that.pciAddress)) return false;
    if (!java.util.Objects.equals(pfPciAddress, that.pfPciAddress)) return false;
    if (!java.util.Objects.equals(rdmaDevice, that.rdmaDevice)) return false;
    if (!java.util.Objects.equals(representorDevice, that.representorDevice)) return false;
    if (!java.util.Objects.equals(vhostNet, that.vhostNet)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(pciAddress,  pfPciAddress,  rdmaDevice,  representorDevice,  vhostNet,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (pciAddress != null) { sb.append("pciAddress:"); sb.append(pciAddress + ","); }
    if (pfPciAddress != null) { sb.append("pfPciAddress:"); sb.append(pfPciAddress + ","); }
    if (rdmaDevice != null) { sb.append("rdmaDevice:"); sb.append(rdmaDevice + ","); }
    if (representorDevice != null) { sb.append("representorDevice:"); sb.append(representorDevice + ","); }
    if (vhostNet != null) { sb.append("vhostNet:"); sb.append(vhostNet + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}