package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DataImageBuilder extends DataImageFluent<DataImageBuilder> implements VisitableBuilder<DataImage,DataImageBuilder>{
  public DataImageBuilder() {
    this(new DataImage());
  }
  
  public DataImageBuilder(DataImageFluent<?> fluent) {
    this(fluent, new DataImage());
  }
  
  public DataImageBuilder(DataImageFluent<?> fluent,DataImage instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DataImageBuilder(DataImage instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DataImageFluent<?> fluent;
  
  public DataImage build() {
    DataImage buildable = new DataImage(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}