package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NICFluent<A extends NICFluent<A>> extends BaseFluent<A>{
  public NICFluent() {
  }
  
  public NICFluent(NIC instance) {
    this.copyInstance(instance);
  }
  private String ip;
  private String mac;
  private String model;
  private String name;
  private Boolean pxe;
  private Integer speedGbps;
  private Integer vlanId;
  private ArrayList<VLANBuilder> vlans = new ArrayList<VLANBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NIC instance) {
    instance = (instance != null ? instance : new NIC());
    if (instance != null) {
          this.withIp(instance.getIp());
          this.withMac(instance.getMac());
          this.withModel(instance.getModel());
          this.withName(instance.getName());
          this.withPxe(instance.getPxe());
          this.withSpeedGbps(instance.getSpeedGbps());
          this.withVlanId(instance.getVlanId());
          this.withVlans(instance.getVlans());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getIp() {
    return this.ip;
  }
  
  public A withIp(String ip) {
    this.ip = ip;
    return (A) this;
  }
  
  public boolean hasIp() {
    return this.ip != null;
  }
  
  public String getMac() {
    return this.mac;
  }
  
  public A withMac(String mac) {
    this.mac = mac;
    return (A) this;
  }
  
  public boolean hasMac() {
    return this.mac != null;
  }
  
  public String getModel() {
    return this.model;
  }
  
  public A withModel(String model) {
    this.model = model;
    return (A) this;
  }
  
  public boolean hasModel() {
    return this.model != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Boolean getPxe() {
    return this.pxe;
  }
  
  public A withPxe(Boolean pxe) {
    this.pxe = pxe;
    return (A) this;
  }
  
  public boolean hasPxe() {
    return this.pxe != null;
  }
  
  public Integer getSpeedGbps() {
    return this.speedGbps;
  }
  
  public A withSpeedGbps(Integer speedGbps) {
    this.speedGbps = speedGbps;
    return (A) this;
  }
  
  public boolean hasSpeedGbps() {
    return this.speedGbps != null;
  }
  
  public Integer getVlanId() {
    return this.vlanId;
  }
  
  public A withVlanId(Integer vlanId) {
    this.vlanId = vlanId;
    return (A) this;
  }
  
  public boolean hasVlanId() {
    return this.vlanId != null;
  }
  
  public A addToVlans(int index,VLAN item) {
    if (this.vlans == null) {this.vlans = new ArrayList<VLANBuilder>();}
    VLANBuilder builder = new VLANBuilder(item);
    if (index < 0 || index >= vlans.size()) {
        _visitables.get("vlans").add(builder);
        vlans.add(builder);
    } else {
        _visitables.get("vlans").add(builder);
        vlans.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToVlans(int index,VLAN item) {
    if (this.vlans == null) {this.vlans = new ArrayList<VLANBuilder>();}
    VLANBuilder builder = new VLANBuilder(item);
    if (index < 0 || index >= vlans.size()) {
        _visitables.get("vlans").add(builder);
        vlans.add(builder);
    } else {
        _visitables.get("vlans").add(builder);
        vlans.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToVlans(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLAN... items) {
    if (this.vlans == null) {this.vlans = new ArrayList<VLANBuilder>();}
    for (VLAN item : items) {VLANBuilder builder = new VLANBuilder(item);_visitables.get("vlans").add(builder);this.vlans.add(builder);} return (A)this;
  }
  
  public A addAllToVlans(Collection<VLAN> items) {
    if (this.vlans == null) {this.vlans = new ArrayList<VLANBuilder>();}
    for (VLAN item : items) {VLANBuilder builder = new VLANBuilder(item);_visitables.get("vlans").add(builder);this.vlans.add(builder);} return (A)this;
  }
  
  public A removeFromVlans(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLAN... items) {
    if (this.vlans == null) return (A)this;
    for (VLAN item : items) {VLANBuilder builder = new VLANBuilder(item);_visitables.get("vlans").remove(builder); this.vlans.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVlans(Collection<VLAN> items) {
    if (this.vlans == null) return (A)this;
    for (VLAN item : items) {VLANBuilder builder = new VLANBuilder(item);_visitables.get("vlans").remove(builder); this.vlans.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVlans(Predicate<VLANBuilder> predicate) {
    if (vlans == null) return (A) this;
    final Iterator<VLANBuilder> each = vlans.iterator();
    final List visitables = _visitables.get("vlans");
    while (each.hasNext()) {
      VLANBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VLAN> buildVlans() {
    return this.vlans != null ? build(vlans) : null;
  }
  
  public VLAN buildVlan(int index) {
    return this.vlans.get(index).build();
  }
  
  public VLAN buildFirstVlan() {
    return this.vlans.get(0).build();
  }
  
  public VLAN buildLastVlan() {
    return this.vlans.get(vlans.size() - 1).build();
  }
  
  public VLAN buildMatchingVlan(Predicate<VLANBuilder> predicate) {
      for (VLANBuilder item : vlans) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVlan(Predicate<VLANBuilder> predicate) {
      for (VLANBuilder item : vlans) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVlans(List<VLAN> vlans) {
    if (this.vlans != null) {
      this._visitables.get("vlans").clear();
    }
    if (vlans != null) {
        this.vlans = new ArrayList();
        for (VLAN item : vlans) {
          this.addToVlans(item);
        }
    } else {
      this.vlans = null;
    }
    return (A) this;
  }
  
  public A withVlans(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.VLAN... vlans) {
    if (this.vlans != null) {
        this.vlans.clear();
        _visitables.remove("vlans");
    }
    if (vlans != null) {
      for (VLAN item : vlans) {
        this.addToVlans(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVlans() {
    return this.vlans != null && !this.vlans.isEmpty();
  }
  
  public A addNewVlan(Integer id,String name) {
    return (A)addToVlans(new VLAN(id, name));
  }
  
  public VlansNested<A> addNewVlan() {
    return new VlansNested(-1, null);
  }
  
  public VlansNested<A> addNewVlanLike(VLAN item) {
    return new VlansNested(-1, item);
  }
  
  public VlansNested<A> setNewVlanLike(int index,VLAN item) {
    return new VlansNested(index, item);
  }
  
  public VlansNested<A> editVlan(int index) {
    if (vlans.size() <= index) throw new RuntimeException("Can't edit vlans. Index exceeds size.");
    return setNewVlanLike(index, buildVlan(index));
  }
  
  public VlansNested<A> editFirstVlan() {
    if (vlans.size() == 0) throw new RuntimeException("Can't edit first vlans. The list is empty.");
    return setNewVlanLike(0, buildVlan(0));
  }
  
  public VlansNested<A> editLastVlan() {
    int index = vlans.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last vlans. The list is empty.");
    return setNewVlanLike(index, buildVlan(index));
  }
  
  public VlansNested<A> editMatchingVlan(Predicate<VLANBuilder> predicate) {
    int index = -1;
    for (int i=0;i<vlans.size();i++) { 
    if (predicate.test(vlans.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching vlans. No match found.");
    return setNewVlanLike(index, buildVlan(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NICFluent that = (NICFluent) o;
    if (!java.util.Objects.equals(ip, that.ip)) return false;
    if (!java.util.Objects.equals(mac, that.mac)) return false;
    if (!java.util.Objects.equals(model, that.model)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(pxe, that.pxe)) return false;
    if (!java.util.Objects.equals(speedGbps, that.speedGbps)) return false;
    if (!java.util.Objects.equals(vlanId, that.vlanId)) return false;
    if (!java.util.Objects.equals(vlans, that.vlans)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ip,  mac,  model,  name,  pxe,  speedGbps,  vlanId,  vlans,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ip != null) { sb.append("ip:"); sb.append(ip + ","); }
    if (mac != null) { sb.append("mac:"); sb.append(mac + ","); }
    if (model != null) { sb.append("model:"); sb.append(model + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (pxe != null) { sb.append("pxe:"); sb.append(pxe + ","); }
    if (speedGbps != null) { sb.append("speedGbps:"); sb.append(speedGbps + ","); }
    if (vlanId != null) { sb.append("vlanId:"); sb.append(vlanId + ","); }
    if (vlans != null && !vlans.isEmpty()) { sb.append("vlans:"); sb.append(vlans + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPxe() {
    return withPxe(true);
  }
  public class VlansNested<N> extends VLANFluent<VlansNested<N>> implements Nested<N>{
    VlansNested(int index,VLAN item) {
      this.index = index;
      this.builder = new VLANBuilder(this, item);
    }
    VLANBuilder builder;
    int index;
    
    public N and() {
      return (N) NICFluent.this.setToVlans(index,builder.build());
    }
    
    public N endVlan() {
      return and();
    }
    
  
  }

}