package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDataFluent<A extends NetworkDataFluent<A>> extends BaseFluent<A>{
  public NetworkDataFluent() {
  }
  
  public NetworkDataFluent(NetworkData instance) {
    this.copyInstance(instance);
  }
  private NetworkDataLinkBuilder links;
  private NetworkDataNetworkBuilder networks;
  private NetworkDataServiceBuilder services;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkData instance) {
    instance = (instance != null ? instance : new NetworkData());
    if (instance != null) {
          this.withLinks(instance.getLinks());
          this.withNetworks(instance.getNetworks());
          this.withServices(instance.getServices());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NetworkDataLink buildLinks() {
    return this.links != null ? this.links.build() : null;
  }
  
  public A withLinks(NetworkDataLink links) {
    this._visitables.remove("links");
    if (links != null) {
        this.links = new NetworkDataLinkBuilder(links);
        this._visitables.get("links").add(this.links);
    } else {
        this.links = null;
        this._visitables.get("links").remove(this.links);
    }
    return (A) this;
  }
  
  public boolean hasLinks() {
    return this.links != null;
  }
  
  public LinksNested<A> withNewLinks() {
    return new LinksNested(null);
  }
  
  public LinksNested<A> withNewLinksLike(NetworkDataLink item) {
    return new LinksNested(item);
  }
  
  public LinksNested<A> editLinks() {
    return withNewLinksLike(java.util.Optional.ofNullable(buildLinks()).orElse(null));
  }
  
  public LinksNested<A> editOrNewLinks() {
    return withNewLinksLike(java.util.Optional.ofNullable(buildLinks()).orElse(new NetworkDataLinkBuilder().build()));
  }
  
  public LinksNested<A> editOrNewLinksLike(NetworkDataLink item) {
    return withNewLinksLike(java.util.Optional.ofNullable(buildLinks()).orElse(item));
  }
  
  public NetworkDataNetwork buildNetworks() {
    return this.networks != null ? this.networks.build() : null;
  }
  
  public A withNetworks(NetworkDataNetwork networks) {
    this._visitables.remove("networks");
    if (networks != null) {
        this.networks = new NetworkDataNetworkBuilder(networks);
        this._visitables.get("networks").add(this.networks);
    } else {
        this.networks = null;
        this._visitables.get("networks").remove(this.networks);
    }
    return (A) this;
  }
  
  public boolean hasNetworks() {
    return this.networks != null;
  }
  
  public NetworksNested<A> withNewNetworks() {
    return new NetworksNested(null);
  }
  
  public NetworksNested<A> withNewNetworksLike(NetworkDataNetwork item) {
    return new NetworksNested(item);
  }
  
  public NetworksNested<A> editNetworks() {
    return withNewNetworksLike(java.util.Optional.ofNullable(buildNetworks()).orElse(null));
  }
  
  public NetworksNested<A> editOrNewNetworks() {
    return withNewNetworksLike(java.util.Optional.ofNullable(buildNetworks()).orElse(new NetworkDataNetworkBuilder().build()));
  }
  
  public NetworksNested<A> editOrNewNetworksLike(NetworkDataNetwork item) {
    return withNewNetworksLike(java.util.Optional.ofNullable(buildNetworks()).orElse(item));
  }
  
  public NetworkDataService buildServices() {
    return this.services != null ? this.services.build() : null;
  }
  
  public A withServices(NetworkDataService services) {
    this._visitables.remove("services");
    if (services != null) {
        this.services = new NetworkDataServiceBuilder(services);
        this._visitables.get("services").add(this.services);
    } else {
        this.services = null;
        this._visitables.get("services").remove(this.services);
    }
    return (A) this;
  }
  
  public boolean hasServices() {
    return this.services != null;
  }
  
  public ServicesNested<A> withNewServices() {
    return new ServicesNested(null);
  }
  
  public ServicesNested<A> withNewServicesLike(NetworkDataService item) {
    return new ServicesNested(item);
  }
  
  public ServicesNested<A> editServices() {
    return withNewServicesLike(java.util.Optional.ofNullable(buildServices()).orElse(null));
  }
  
  public ServicesNested<A> editOrNewServices() {
    return withNewServicesLike(java.util.Optional.ofNullable(buildServices()).orElse(new NetworkDataServiceBuilder().build()));
  }
  
  public ServicesNested<A> editOrNewServicesLike(NetworkDataService item) {
    return withNewServicesLike(java.util.Optional.ofNullable(buildServices()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDataFluent that = (NetworkDataFluent) o;
    if (!java.util.Objects.equals(links, that.links)) return false;
    if (!java.util.Objects.equals(networks, that.networks)) return false;
    if (!java.util.Objects.equals(services, that.services)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(links,  networks,  services,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (links != null) { sb.append("links:"); sb.append(links + ","); }
    if (networks != null) { sb.append("networks:"); sb.append(networks + ","); }
    if (services != null) { sb.append("services:"); sb.append(services + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LinksNested<N> extends NetworkDataLinkFluent<LinksNested<N>> implements Nested<N>{
    LinksNested(NetworkDataLink item) {
      this.builder = new NetworkDataLinkBuilder(this, item);
    }
    NetworkDataLinkBuilder builder;
    
    public N and() {
      return (N) NetworkDataFluent.this.withLinks(builder.build());
    }
    
    public N endLinks() {
      return and();
    }
    
  
  }
  public class NetworksNested<N> extends NetworkDataNetworkFluent<NetworksNested<N>> implements Nested<N>{
    NetworksNested(NetworkDataNetwork item) {
      this.builder = new NetworkDataNetworkBuilder(this, item);
    }
    NetworkDataNetworkBuilder builder;
    
    public N and() {
      return (N) NetworkDataFluent.this.withNetworks(builder.build());
    }
    
    public N endNetworks() {
      return and();
    }
    
  
  }
  public class ServicesNested<N> extends NetworkDataServiceFluent<ServicesNested<N>> implements Nested<N>{
    ServicesNested(NetworkDataService item) {
      this.builder = new NetworkDataServiceBuilder(this, item);
    }
    NetworkDataServiceBuilder builder;
    
    public N and() {
      return (N) NetworkDataFluent.this.withServices(builder.build());
    }
    
    public N endServices() {
      return and();
    }
    
  
  }

}