package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDataRoutev6Fluent<A extends NetworkDataRoutev6Fluent<A>> extends BaseFluent<A>{
  public NetworkDataRoutev6Fluent() {
  }
  
  public NetworkDataRoutev6Fluent(NetworkDataRoutev6 instance) {
    this.copyInstance(instance);
  }
  private NetworkGatewayv6Builder gateway;
  private String network;
  private Integer prefix;
  private NetworkDataServicev6Builder services;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkDataRoutev6 instance) {
    instance = (instance != null ? instance : new NetworkDataRoutev6());
    if (instance != null) {
          this.withGateway(instance.getGateway());
          this.withNetwork(instance.getNetwork());
          this.withPrefix(instance.getPrefix());
          this.withServices(instance.getServices());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NetworkGatewayv6 buildGateway() {
    return this.gateway != null ? this.gateway.build() : null;
  }
  
  public A withGateway(NetworkGatewayv6 gateway) {
    this._visitables.remove("gateway");
    if (gateway != null) {
        this.gateway = new NetworkGatewayv6Builder(gateway);
        this._visitables.get("gateway").add(this.gateway);
    } else {
        this.gateway = null;
        this._visitables.get("gateway").remove(this.gateway);
    }
    return (A) this;
  }
  
  public boolean hasGateway() {
    return this.gateway != null;
  }
  
  public A withNewGateway(String fromIPPool,String string) {
    return (A)withGateway(new NetworkGatewayv6(fromIPPool, string));
  }
  
  public GatewayNested<A> withNewGateway() {
    return new GatewayNested(null);
  }
  
  public GatewayNested<A> withNewGatewayLike(NetworkGatewayv6 item) {
    return new GatewayNested(item);
  }
  
  public GatewayNested<A> editGateway() {
    return withNewGatewayLike(java.util.Optional.ofNullable(buildGateway()).orElse(null));
  }
  
  public GatewayNested<A> editOrNewGateway() {
    return withNewGatewayLike(java.util.Optional.ofNullable(buildGateway()).orElse(new NetworkGatewayv6Builder().build()));
  }
  
  public GatewayNested<A> editOrNewGatewayLike(NetworkGatewayv6 item) {
    return withNewGatewayLike(java.util.Optional.ofNullable(buildGateway()).orElse(item));
  }
  
  public String getNetwork() {
    return this.network;
  }
  
  public A withNetwork(String network) {
    this.network = network;
    return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public Integer getPrefix() {
    return this.prefix;
  }
  
  public A withPrefix(Integer prefix) {
    this.prefix = prefix;
    return (A) this;
  }
  
  public boolean hasPrefix() {
    return this.prefix != null;
  }
  
  public NetworkDataServicev6 buildServices() {
    return this.services != null ? this.services.build() : null;
  }
  
  public A withServices(NetworkDataServicev6 services) {
    this._visitables.remove("services");
    if (services != null) {
        this.services = new NetworkDataServicev6Builder(services);
        this._visitables.get("services").add(this.services);
    } else {
        this.services = null;
        this._visitables.get("services").remove(this.services);
    }
    return (A) this;
  }
  
  public boolean hasServices() {
    return this.services != null;
  }
  
  public ServicesNested<A> withNewServices() {
    return new ServicesNested(null);
  }
  
  public ServicesNested<A> withNewServicesLike(NetworkDataServicev6 item) {
    return new ServicesNested(item);
  }
  
  public ServicesNested<A> editServices() {
    return withNewServicesLike(java.util.Optional.ofNullable(buildServices()).orElse(null));
  }
  
  public ServicesNested<A> editOrNewServices() {
    return withNewServicesLike(java.util.Optional.ofNullable(buildServices()).orElse(new NetworkDataServicev6Builder().build()));
  }
  
  public ServicesNested<A> editOrNewServicesLike(NetworkDataServicev6 item) {
    return withNewServicesLike(java.util.Optional.ofNullable(buildServices()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDataRoutev6Fluent that = (NetworkDataRoutev6Fluent) o;
    if (!java.util.Objects.equals(gateway, that.gateway)) return false;
    if (!java.util.Objects.equals(network, that.network)) return false;
    if (!java.util.Objects.equals(prefix, that.prefix)) return false;
    if (!java.util.Objects.equals(services, that.services)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(gateway,  network,  prefix,  services,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (gateway != null) { sb.append("gateway:"); sb.append(gateway + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (prefix != null) { sb.append("prefix:"); sb.append(prefix + ","); }
    if (services != null) { sb.append("services:"); sb.append(services + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GatewayNested<N> extends NetworkGatewayv6Fluent<GatewayNested<N>> implements Nested<N>{
    GatewayNested(NetworkGatewayv6 item) {
      this.builder = new NetworkGatewayv6Builder(this, item);
    }
    NetworkGatewayv6Builder builder;
    
    public N and() {
      return (N) NetworkDataRoutev6Fluent.this.withGateway(builder.build());
    }
    
    public N endGateway() {
      return and();
    }
    
  
  }
  public class ServicesNested<N> extends NetworkDataServicev6Fluent<ServicesNested<N>> implements Nested<N>{
    ServicesNested(NetworkDataServicev6 item) {
      this.builder = new NetworkDataServicev6Builder(this, item);
    }
    NetworkDataServicev6Builder builder;
    
    public N and() {
      return (N) NetworkDataRoutev6Fluent.this.withServices(builder.build());
    }
    
    public N endServices() {
      return and();
    }
    
  
  }

}