/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.AttachedImageReference;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.AttachedImageReferenceBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.AttachedImageReferenceFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageError;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageErrorBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageErrorFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.DataImageStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataImageStatusFluent<A extends DataImageStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AttachedImageReferenceBuilder attachedImage;
    private DataImageErrorBuilder error;
    private String lastReconciled;

    public DataImageStatusFluent() {
    }

    public DataImageStatusFluent(DataImageStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public AttachedImageReference buildAttachedImage() {
        return this.attachedImage != null ? this.attachedImage.build() : null;
    }

    public DataImageError buildError() {
        return this.error != null ? this.error.build() : null;
    }

    protected void copyInstance(DataImageStatus instance) {
        DataImageStatus dataImageStatus = instance = instance != null ? instance : new DataImageStatus();
        if (instance != null) {
            this.withAttachedImage(instance.getAttachedImage());
            this.withError(instance.getError());
            this.withLastReconciled(instance.getLastReconciled());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AttachedImageNested<A> editAttachedImage() {
        return this.withNewAttachedImageLike(Optional.ofNullable(this.buildAttachedImage()).orElse(null));
    }

    public ErrorNested<A> editError() {
        return this.withNewErrorLike(Optional.ofNullable(this.buildError()).orElse(null));
    }

    public AttachedImageNested<A> editOrNewAttachedImage() {
        return this.withNewAttachedImageLike(Optional.ofNullable(this.buildAttachedImage()).orElse(new AttachedImageReferenceBuilder().build()));
    }

    public AttachedImageNested<A> editOrNewAttachedImageLike(AttachedImageReference item) {
        return this.withNewAttachedImageLike(Optional.ofNullable(this.buildAttachedImage()).orElse(item));
    }

    public ErrorNested<A> editOrNewError() {
        return this.withNewErrorLike(Optional.ofNullable(this.buildError()).orElse(new DataImageErrorBuilder().build()));
    }

    public ErrorNested<A> editOrNewErrorLike(DataImageError item) {
        return this.withNewErrorLike(Optional.ofNullable(this.buildError()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataImageStatusFluent that = (DataImageStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.attachedImage, (Object)that.attachedImage)) {
            return false;
        }
        if (!Objects.equals((Object)this.error, (Object)that.error)) {
            return false;
        }
        if (!Objects.equals(this.lastReconciled, that.lastReconciled)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getLastReconciled() {
        return this.lastReconciled;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAttachedImage() {
        return this.attachedImage != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean hasLastReconciled() {
        return this.lastReconciled != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachedImage, this.error, this.lastReconciled, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachedImage != null) {
            sb.append("attachedImage:");
            sb.append((Object)this.attachedImage);
            sb.append(",");
        }
        if (this.error != null) {
            sb.append("error:");
            sb.append((Object)this.error);
            sb.append(",");
        }
        if (this.lastReconciled != null) {
            sb.append("lastReconciled:");
            sb.append(this.lastReconciled);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAttachedImage(AttachedImageReference attachedImage) {
        this._visitables.remove((Object)"attachedImage");
        if (attachedImage != null) {
            this.attachedImage = new AttachedImageReferenceBuilder(attachedImage);
            this._visitables.get((Object)"attachedImage").add(this.attachedImage);
        } else {
            this.attachedImage = null;
            this._visitables.get((Object)"attachedImage").remove((Object)this.attachedImage);
        }
        return (A)((Object)this);
    }

    public A withError(DataImageError error) {
        this._visitables.remove((Object)"error");
        if (error != null) {
            this.error = new DataImageErrorBuilder(error);
            this._visitables.get((Object)"error").add(this.error);
        } else {
            this.error = null;
            this._visitables.get((Object)"error").remove((Object)this.error);
        }
        return (A)((Object)this);
    }

    public A withLastReconciled(String lastReconciled) {
        this.lastReconciled = lastReconciled;
        return (A)((Object)this);
    }

    public AttachedImageNested<A> withNewAttachedImage() {
        return new AttachedImageNested(null);
    }

    public A withNewAttachedImage(String url) {
        return this.withAttachedImage(new AttachedImageReference(url));
    }

    public AttachedImageNested<A> withNewAttachedImageLike(AttachedImageReference item) {
        return new AttachedImageNested(item);
    }

    public ErrorNested<A> withNewError() {
        return new ErrorNested(null);
    }

    public A withNewError(Integer count, String message) {
        return this.withError(new DataImageError(count, message));
    }

    public ErrorNested<A> withNewErrorLike(DataImageError item) {
        return new ErrorNested(item);
    }

    public class ErrorNested<N>
    extends DataImageErrorFluent<ErrorNested<N>>
    implements Nested<N> {
        DataImageErrorBuilder builder;

        ErrorNested(DataImageError item) {
            this.builder = new DataImageErrorBuilder(this, item);
        }

        public N and() {
            return (N)DataImageStatusFluent.this.withError(this.builder.build());
        }

        public N endError() {
            return this.and();
        }
    }

    public class AttachedImageNested<N>
    extends AttachedImageReferenceFluent<AttachedImageNested<N>>
    implements Nested<N> {
        AttachedImageReferenceBuilder builder;

        AttachedImageNested(AttachedImageReference item) {
            this.builder = new AttachedImageReferenceBuilder(this, item);
        }

        public N and() {
            return (N)DataImageStatusFluent.this.withAttachedImage(this.builder.build());
        }

        public N endAttachedImage() {
            return this.and();
        }
    }
}

