package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TelegramConfigBuilder extends TelegramConfigFluent<TelegramConfigBuilder> implements VisitableBuilder<TelegramConfig,TelegramConfigBuilder>{
  public TelegramConfigBuilder() {
    this(new TelegramConfig());
  }
  
  public TelegramConfigBuilder(TelegramConfigFluent<?> fluent) {
    this(fluent, new TelegramConfig());
  }
  
  public TelegramConfigBuilder(TelegramConfigFluent<?> fluent,TelegramConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TelegramConfigBuilder(TelegramConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TelegramConfigFluent<?> fluent;
  
  public TelegramConfig build() {
    TelegramConfig buildable = new TelegramConfig(fluent.getApiURL(),fluent.getBotToken(),fluent.getBotTokenFile(),fluent.getChatID(),fluent.getDisableNotifications(),fluent.buildHttpConfig(),fluent.getMessage(),fluent.getParseMode(),fluent.getSendResolved());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}