package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ThanosRulerStatusBuilder extends ThanosRulerStatusFluent<ThanosRulerStatusBuilder> implements VisitableBuilder<ThanosRulerStatus,ThanosRulerStatusBuilder>{
  public ThanosRulerStatusBuilder() {
    this(new ThanosRulerStatus());
  }
  
  public ThanosRulerStatusBuilder(ThanosRulerStatusFluent<?> fluent) {
    this(fluent, new ThanosRulerStatus());
  }
  
  public ThanosRulerStatusBuilder(ThanosRulerStatusFluent<?> fluent,ThanosRulerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ThanosRulerStatusBuilder(ThanosRulerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ThanosRulerStatusFluent<?> fluent;
  
  public ThanosRulerStatus build() {
    ThanosRulerStatus buildable = new ThanosRulerStatus(fluent.getAvailableReplicas(),fluent.buildConditions(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}