package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PushoverConfigBuilder extends PushoverConfigFluent<PushoverConfigBuilder> implements VisitableBuilder<PushoverConfig,PushoverConfigBuilder>{
  public PushoverConfigBuilder() {
    this(new PushoverConfig());
  }
  
  public PushoverConfigBuilder(PushoverConfigFluent<?> fluent) {
    this(fluent, new PushoverConfig());
  }
  
  public PushoverConfigBuilder(PushoverConfigFluent<?> fluent,PushoverConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PushoverConfigBuilder(PushoverConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PushoverConfigFluent<?> fluent;
  
  public PushoverConfig build() {
    PushoverConfig buildable = new PushoverConfig(fluent.getExpire(),fluent.getHtml(),fluent.buildHttpConfig(),fluent.getMessage(),fluent.getPriority(),fluent.getRetry(),fluent.getSendResolved(),fluent.getSound(),fluent.getTitle(),fluent.getToken(),fluent.getUrl(),fluent.getUrlTitle(),fluent.getUserKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}