package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TLSConfigBuilder extends TLSConfigFluent<TLSConfigBuilder> implements VisitableBuilder<TLSConfig,TLSConfigBuilder>{
  public TLSConfigBuilder() {
    this(new TLSConfig());
  }
  
  public TLSConfigBuilder(TLSConfigFluent<?> fluent) {
    this(fluent, new TLSConfig());
  }
  
  public TLSConfigBuilder(TLSConfigFluent<?> fluent,TLSConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TLSConfigBuilder(TLSConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TLSConfigFluent<?> fluent;
  
  public TLSConfig build() {
    TLSConfig buildable = new TLSConfig(fluent.buildCa(),fluent.getCaFile(),fluent.buildCert(),fluent.getCertFile(),fluent.getInsecureSkipVerify(),fluent.getKeyFile(),fluent.getKeySecret(),fluent.getServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}