package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EmbeddedPersistentVolumeClaimFluentImpl<A extends EmbeddedPersistentVolumeClaimFluent<A>> extends BaseFluent<A> implements EmbeddedPersistentVolumeClaimFluent<A>{
  public EmbeddedPersistentVolumeClaimFluentImpl() {
  }
  public EmbeddedPersistentVolumeClaimFluentImpl(EmbeddedPersistentVolumeClaim instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private EmbeddedObjectMetadataBuilder metadata;
  private PersistentVolumeClaimSpec spec;
  private PersistentVolumeClaimStatus status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public EmbeddedObjectMetadata getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public EmbeddedObjectMetadata buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(EmbeddedObjectMetadata metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new EmbeddedObjectMetadataBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> withNewMetadata() {
    return new EmbeddedPersistentVolumeClaimFluentImpl.MetadataNestedImpl();
  }
  public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> withNewMetadataLike(EmbeddedObjectMetadata item) {
    return new EmbeddedPersistentVolumeClaimFluentImpl.MetadataNestedImpl(item);
  }
  public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new EmbeddedObjectMetadataBuilder().build());
  }
  public EmbeddedPersistentVolumeClaimFluent.MetadataNested<A> editOrNewMetadataLike(EmbeddedObjectMetadata item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public PersistentVolumeClaimSpec getSpec() {
    return this.spec;
  }
  public A withSpec(PersistentVolumeClaimSpec spec) {
    this.spec=spec; return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PersistentVolumeClaimStatus getStatus() {
    return this.status;
  }
  public A withStatus(PersistentVolumeClaimStatus status) {
    this.status=status; return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EmbeddedPersistentVolumeClaimFluentImpl that = (EmbeddedPersistentVolumeClaimFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends EmbeddedObjectMetadataFluentImpl<EmbeddedPersistentVolumeClaimFluent.MetadataNested<N>> implements EmbeddedPersistentVolumeClaimFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(EmbeddedObjectMetadata item) {
      this.builder = new EmbeddedObjectMetadataBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new EmbeddedObjectMetadataBuilder(this);
    }
    EmbeddedObjectMetadataBuilder builder;
    public N and() {
      return (N) EmbeddedPersistentVolumeClaimFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}