package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
public interface PodMonitorSpecFluent<A extends PodMonitorSpecFluent<A>> extends Fluent<A>{
  public String getJobLabel();
  public A withJobLabel(String jobLabel);
  public Boolean hasJobLabel();
  public Long getLabelLimit();
  public A withLabelLimit(Long labelLimit);
  public Boolean hasLabelLimit();
  public Long getLabelNameLengthLimit();
  public A withLabelNameLengthLimit(Long labelNameLengthLimit);
  public Boolean hasLabelNameLengthLimit();
  public Long getLabelValueLengthLimit();
  public A withLabelValueLengthLimit(Long labelValueLengthLimit);
  public Boolean hasLabelValueLengthLimit();
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceSelector getNamespaceSelector();
  public NamespaceSelector buildNamespaceSelector();
  public A withNamespaceSelector(NamespaceSelector namespaceSelector);
  public Boolean hasNamespaceSelector();
  public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
  public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item);
  public PodMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector();
  public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
  public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item);
  public A addToPodMetricsEndpoints(Integer index,PodMetricsEndpoint item);
  public A setToPodMetricsEndpoints(Integer index,PodMetricsEndpoint item);
  public A addToPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... items);
  public A addAllToPodMetricsEndpoints(Collection<PodMetricsEndpoint> items);
  public A removeFromPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... items);
  public A removeAllFromPodMetricsEndpoints(Collection<PodMetricsEndpoint> items);
  public A removeMatchingFromPodMetricsEndpoints(Predicate<PodMetricsEndpointBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPodMetricsEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodMetricsEndpoint> getPodMetricsEndpoints();
  public List<PodMetricsEndpoint> buildPodMetricsEndpoints();
  public PodMetricsEndpoint buildPodMetricsEndpoint(Integer index);
  public PodMetricsEndpoint buildFirstPodMetricsEndpoint();
  public PodMetricsEndpoint buildLastPodMetricsEndpoint();
  public PodMetricsEndpoint buildMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate);
  public Boolean hasMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate);
  public A withPodMetricsEndpoints(List<PodMetricsEndpoint> podMetricsEndpoints);
  public A withPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... podMetricsEndpoints);
  public Boolean hasPodMetricsEndpoints();
  public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpoint();
  public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpointLike(PodMetricsEndpoint item);
  public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> setNewPodMetricsEndpointLike(Integer index,PodMetricsEndpoint item);
  public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editPodMetricsEndpoint(Integer index);
  public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editFirstPodMetricsEndpoint();
  public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editLastPodMetricsEndpoint();
  public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate);
  public A addToPodTargetLabels(Integer index,String item);
  public A setToPodTargetLabels(Integer index,String item);
  public A addToPodTargetLabels(java.lang.String... items);
  public A addAllToPodTargetLabels(Collection<String> items);
  public A removeFromPodTargetLabels(java.lang.String... items);
  public A removeAllFromPodTargetLabels(Collection<String> items);
  public List<String> getPodTargetLabels();
  public String getPodTargetLabel(Integer index);
  public String getFirstPodTargetLabel();
  public String getLastPodTargetLabel();
  public String getMatchingPodTargetLabel(Predicate<String> predicate);
  public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate);
  public A withPodTargetLabels(List<String> podTargetLabels);
  public A withPodTargetLabels(java.lang.String... podTargetLabels);
  public Boolean hasPodTargetLabels();
  public Long getSampleLimit();
  public A withSampleLimit(Long sampleLimit);
  public Boolean hasSampleLimit();
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector();
  public LabelSelector buildSelector();
  public A withSelector(LabelSelector selector);
  public Boolean hasSelector();
  public PodMonitorSpecFluent.SelectorNested<A> withNewSelector();
  public PodMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
  public PodMonitorSpecFluent.SelectorNested<A> editSelector();
  public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelector();
  public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
  public Long getTargetLimit();
  public A withTargetLimit(Long targetLimit);
  public Boolean hasTargetLimit();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface NamespaceSelectorNested<N> extends Nested<N>,NamespaceSelectorFluent<PodMonitorSpecFluent.NamespaceSelectorNested<N>>{
    public N and();
    public N endNamespaceSelector();
    
  }
  public interface PodMetricsEndpointsNested<N> extends Nested<N>,PodMetricsEndpointFluent<PodMonitorSpecFluent.PodMetricsEndpointsNested<N>>{
    public N and();
    public N endPodMetricsEndpoint();
    
  }
  public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<PodMonitorSpecFluent.SelectorNested<N>>{
    public N and();
    public N endSelector();
    
  }
  
}