package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeSpecBuilder extends ProbeSpecFluentImpl<ProbeSpecBuilder> implements VisitableBuilder<ProbeSpec,ProbeSpecBuilder>{
  public ProbeSpecBuilder() {
    this(false);
  }
  public ProbeSpecBuilder(Boolean validationEnabled) {
    this(new ProbeSpec(), validationEnabled);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProbeSpec(), validationEnabled);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent,ProbeSpec instance) {
    this(fluent, instance, false);
  }
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent,ProbeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorization(instance.getAuthorization()); 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    fluent.withInterval(instance.getInterval()); 
    fluent.withJobName(instance.getJobName()); 
    fluent.withLabelLimit(instance.getLabelLimit()); 
    fluent.withLabelNameLengthLimit(instance.getLabelNameLengthLimit()); 
    fluent.withLabelValueLengthLimit(instance.getLabelValueLengthLimit()); 
    fluent.withMetricRelabelings(instance.getMetricRelabelings()); 
    fluent.withModule(instance.getModule()); 
    fluent.withOauth2(instance.getOauth2()); 
    fluent.withProber(instance.getProber()); 
    fluent.withSampleLimit(instance.getSampleLimit()); 
    fluent.withScrapeTimeout(instance.getScrapeTimeout()); 
    fluent.withTargetLimit(instance.getTargetLimit()); 
    fluent.withTargets(instance.getTargets()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProbeSpecBuilder(ProbeSpec instance) {
    this(instance,false);
  }
  public ProbeSpecBuilder(ProbeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withInterval(instance.getInterval()); 
    this.withJobName(instance.getJobName()); 
    this.withLabelLimit(instance.getLabelLimit()); 
    this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit()); 
    this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit()); 
    this.withMetricRelabelings(instance.getMetricRelabelings()); 
    this.withModule(instance.getModule()); 
    this.withOauth2(instance.getOauth2()); 
    this.withProber(instance.getProber()); 
    this.withSampleLimit(instance.getSampleLimit()); 
    this.withScrapeTimeout(instance.getScrapeTimeout()); 
    this.withTargetLimit(instance.getTargetLimit()); 
    this.withTargets(instance.getTargets()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProbeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ProbeSpec build() {
    ProbeSpec buildable = new ProbeSpec(fluent.getAuthorization(),fluent.getBasicAuth(),fluent.getBearerTokenSecret(),fluent.getInterval(),fluent.getJobName(),fluent.getLabelLimit(),fluent.getLabelNameLengthLimit(),fluent.getLabelValueLengthLimit(),fluent.getMetricRelabelings(),fluent.getModule(),fluent.getOauth2(),fluent.getProber(),fluent.getSampleLimit(),fluent.getScrapeTimeout(),fluent.getTargetLimit(),fluent.getTargets(),fluent.getTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}