package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SafeTLSConfigBuilder extends SafeTLSConfigFluentImpl<SafeTLSConfigBuilder> implements VisitableBuilder<SafeTLSConfig,SafeTLSConfigBuilder>{
  public SafeTLSConfigBuilder() {
    this(false);
  }
  public SafeTLSConfigBuilder(Boolean validationEnabled) {
    this(new SafeTLSConfig(), validationEnabled);
  }
  public SafeTLSConfigBuilder(SafeTLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public SafeTLSConfigBuilder(SafeTLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SafeTLSConfig(), validationEnabled);
  }
  public SafeTLSConfigBuilder(SafeTLSConfigFluent<?> fluent,SafeTLSConfig instance) {
    this(fluent, instance, false);
  }
  public SafeTLSConfigBuilder(SafeTLSConfigFluent<?> fluent,SafeTLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withCert(instance.getCert()); 
    fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    fluent.withKeySecret(instance.getKeySecret()); 
    fluent.withServerName(instance.getServerName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SafeTLSConfigBuilder(SafeTLSConfig instance) {
    this(instance,false);
  }
  public SafeTLSConfigBuilder(SafeTLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withCert(instance.getCert()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withKeySecret(instance.getKeySecret()); 
    this.withServerName(instance.getServerName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SafeTLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public SafeTLSConfig build() {
    SafeTLSConfig buildable = new SafeTLSConfig(fluent.getCa(),fluent.getCert(),fluent.getInsecureSkipVerify(),fluent.getKeySecret(),fluent.getServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}