package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceMonitorSpecFluentImpl<A extends ServiceMonitorSpecFluent<A>> extends BaseFluent<A> implements ServiceMonitorSpecFluent<A>{
  public ServiceMonitorSpecFluentImpl() {
  }
  public ServiceMonitorSpecFluentImpl(ServiceMonitorSpec instance) {
    this.withEndpoints(instance.getEndpoints()); 
    this.withJobLabel(instance.getJobLabel()); 
    this.withLabelLimit(instance.getLabelLimit()); 
    this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit()); 
    this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPodTargetLabels(instance.getPodTargetLabels()); 
    this.withSampleLimit(instance.getSampleLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withTargetLabels(instance.getTargetLabels()); 
    this.withTargetLimit(instance.getTargetLimit()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<EndpointBuilder> endpoints = new ArrayList<EndpointBuilder>();
  private String jobLabel;
  private Long labelLimit;
  private Long labelNameLengthLimit;
  private Long labelValueLengthLimit;
  private NamespaceSelectorBuilder namespaceSelector;
  private List<String> podTargetLabels = new ArrayList<String>();
  private Long sampleLimit;
  private LabelSelectorBuilder selector;
  private List<String> targetLabels = new ArrayList<String>();
  private Long targetLimit;
  private Map<String,Object> additionalProperties;
  public A addToEndpoints(Integer index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
  }
  public A setToEndpoints(Integer index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);
    if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
    if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
     return (A)this;
  }
  public A addToEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A addAllToEndpoints(Collection<Endpoint> items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A removeFromEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items) {
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpoints(Collection<Endpoint> items) {
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<EndpointBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      EndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Endpoint> getEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public List<Endpoint> buildEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public Endpoint buildEndpoint(Integer index) {
    return this.endpoints.get(index).build();
  }
  public Endpoint buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  public Endpoint buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndpoints(List<Endpoint> endpoints) {
    if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
    if (endpoints != null) {this.endpoints = new ArrayList(); for (Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
  }
  public A withEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... endpoints) {
    if (this.endpoints != null) {this.endpoints.clear();}
    if (endpoints != null) {for (Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
  }
  public Boolean hasEndpoints() {
    return endpoints != null && !endpoints.isEmpty();
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint() {
    return new ServiceMonitorSpecFluentImpl.EndpointsNestedImpl();
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
    return new ServiceMonitorSpecFluentImpl.EndpointsNestedImpl(-1, item);
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(Integer index,Endpoint item) {
    return new ServiceMonitorSpecFluentImpl.EndpointsNestedImpl(index, item);
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(Integer index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public String getJobLabel() {
    return this.jobLabel;
  }
  public A withJobLabel(String jobLabel) {
    this.jobLabel=jobLabel; return (A) this;
  }
  public Boolean hasJobLabel() {
    return this.jobLabel != null;
  }
  public Long getLabelLimit() {
    return this.labelLimit;
  }
  public A withLabelLimit(Long labelLimit) {
    this.labelLimit=labelLimit; return (A) this;
  }
  public Boolean hasLabelLimit() {
    return this.labelLimit != null;
  }
  public Long getLabelNameLengthLimit() {
    return this.labelNameLengthLimit;
  }
  public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
    this.labelNameLengthLimit=labelNameLengthLimit; return (A) this;
  }
  public Boolean hasLabelNameLengthLimit() {
    return this.labelNameLengthLimit != null;
  }
  public Long getLabelValueLengthLimit() {
    return this.labelValueLengthLimit;
  }
  public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
    this.labelValueLengthLimit=labelValueLengthLimit; return (A) this;
  }
  public Boolean hasLabelValueLengthLimit() {
    return this.labelValueLengthLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new ServiceMonitorSpecFluentImpl.NamespaceSelectorNestedImpl();
  }
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new ServiceMonitorSpecFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new NamespaceSelectorBuilder().build());
  }
  public ServiceMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  public A addToPodTargetLabels(Integer index,String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    this.podTargetLabels.add(index, item);
    return (A)this;
  }
  public A setToPodTargetLabels(Integer index,String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    this.podTargetLabels.set(index, item); return (A)this;
  }
  public A addToPodTargetLabels(java.lang.String... items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  public A addAllToPodTargetLabels(Collection<String> items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  public A removeFromPodTargetLabels(java.lang.String... items) {
    for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
  }
  public A removeAllFromPodTargetLabels(Collection<String> items) {
    for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
  }
  public List<String> getPodTargetLabels() {
    return this.podTargetLabels;
  }
  public String getPodTargetLabel(Integer index) {
    return this.podTargetLabels.get(index);
  }
  public String getFirstPodTargetLabel() {
    return this.podTargetLabels.get(0);
  }
  public String getLastPodTargetLabel() {
    return this.podTargetLabels.get(podTargetLabels.size() - 1);
  }
  public String getMatchingPodTargetLabel(Predicate<String> predicate) {
    for (String item: podTargetLabels) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
    for (String item: podTargetLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodTargetLabels(List<String> podTargetLabels) {
    if (podTargetLabels != null) {this.podTargetLabels = new ArrayList(); for (String item : podTargetLabels){this.addToPodTargetLabels(item);}} else { this.podTargetLabels = null;} return (A) this;
  }
  public A withPodTargetLabels(java.lang.String... podTargetLabels) {
    if (this.podTargetLabels != null) {this.podTargetLabels.clear();}
    if (podTargetLabels != null) {for (String item :podTargetLabels){ this.addToPodTargetLabels(item);}} return (A) this;
  }
  public Boolean hasPodTargetLabels() {
    return podTargetLabels != null && !podTargetLabels.isEmpty();
  }
  public Long getSampleLimit() {
    return this.sampleLimit;
  }
  public A withSampleLimit(Long sampleLimit) {
    this.sampleLimit=sampleLimit; return (A) this;
  }
  public Boolean hasSampleLimit() {
    return this.sampleLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector() {
    return new ServiceMonitorSpecFluentImpl.SelectorNestedImpl();
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new ServiceMonitorSpecFluentImpl.SelectorNestedImpl(item);
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public A addToTargetLabels(Integer index,String item) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    this.targetLabels.add(index, item);
    return (A)this;
  }
  public A setToTargetLabels(Integer index,String item) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    this.targetLabels.set(index, item); return (A)this;
  }
  public A addToTargetLabels(java.lang.String... items) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    for (String item : items) {this.targetLabels.add(item);} return (A)this;
  }
  public A addAllToTargetLabels(Collection<String> items) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    for (String item : items) {this.targetLabels.add(item);} return (A)this;
  }
  public A removeFromTargetLabels(java.lang.String... items) {
    for (String item : items) {if (this.targetLabels!= null){ this.targetLabels.remove(item);}} return (A)this;
  }
  public A removeAllFromTargetLabels(Collection<String> items) {
    for (String item : items) {if (this.targetLabels!= null){ this.targetLabels.remove(item);}} return (A)this;
  }
  public List<String> getTargetLabels() {
    return this.targetLabels;
  }
  public String getTargetLabel(Integer index) {
    return this.targetLabels.get(index);
  }
  public String getFirstTargetLabel() {
    return this.targetLabels.get(0);
  }
  public String getLastTargetLabel() {
    return this.targetLabels.get(targetLabels.size() - 1);
  }
  public String getMatchingTargetLabel(Predicate<String> predicate) {
    for (String item: targetLabels) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTargetLabel(Predicate<String> predicate) {
    for (String item: targetLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTargetLabels(List<String> targetLabels) {
    if (targetLabels != null) {this.targetLabels = new ArrayList(); for (String item : targetLabels){this.addToTargetLabels(item);}} else { this.targetLabels = null;} return (A) this;
  }
  public A withTargetLabels(java.lang.String... targetLabels) {
    if (this.targetLabels != null) {this.targetLabels.clear();}
    if (targetLabels != null) {for (String item :targetLabels){ this.addToTargetLabels(item);}} return (A) this;
  }
  public Boolean hasTargetLabels() {
    return targetLabels != null && !targetLabels.isEmpty();
  }
  public Long getTargetLimit() {
    return this.targetLimit;
  }
  public A withTargetLimit(Long targetLimit) {
    this.targetLimit=targetLimit; return (A) this;
  }
  public Boolean hasTargetLimit() {
    return this.targetLimit != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceMonitorSpecFluentImpl that = (ServiceMonitorSpecFluentImpl) o;
    if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
    if (jobLabel != null ? !jobLabel.equals(that.jobLabel) :that.jobLabel != null) return false;
    if (labelLimit != null ? !labelLimit.equals(that.labelLimit) :that.labelLimit != null) return false;
    if (labelNameLengthLimit != null ? !labelNameLengthLimit.equals(that.labelNameLengthLimit) :that.labelNameLengthLimit != null) return false;
    if (labelValueLengthLimit != null ? !labelValueLengthLimit.equals(that.labelValueLengthLimit) :that.labelValueLengthLimit != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (podTargetLabels != null ? !podTargetLabels.equals(that.podTargetLabels) :that.podTargetLabels != null) return false;
    if (sampleLimit != null ? !sampleLimit.equals(that.sampleLimit) :that.sampleLimit != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (targetLabels != null ? !targetLabels.equals(that.targetLabels) :that.targetLabels != null) return false;
    if (targetLimit != null ? !targetLimit.equals(that.targetLimit) :that.targetLimit != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(endpoints,  jobLabel,  labelLimit,  labelNameLengthLimit,  labelValueLengthLimit,  namespaceSelector,  podTargetLabels,  sampleLimit,  selector,  targetLabels,  targetLimit,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (endpoints != null && !endpoints.isEmpty()) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (jobLabel != null) { sb.append("jobLabel:"); sb.append(jobLabel + ","); }
    if (labelLimit != null) { sb.append("labelLimit:"); sb.append(labelLimit + ","); }
    if (labelNameLengthLimit != null) { sb.append("labelNameLengthLimit:"); sb.append(labelNameLengthLimit + ","); }
    if (labelValueLengthLimit != null) { sb.append("labelValueLengthLimit:"); sb.append(labelValueLengthLimit + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (podTargetLabels != null && !podTargetLabels.isEmpty()) { sb.append("podTargetLabels:"); sb.append(podTargetLabels + ","); }
    if (sampleLimit != null) { sb.append("sampleLimit:"); sb.append(sampleLimit + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (targetLabels != null && !targetLabels.isEmpty()) { sb.append("targetLabels:"); sb.append(targetLabels + ","); }
    if (targetLimit != null) { sb.append("targetLimit:"); sb.append(targetLimit + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class EndpointsNestedImpl<N> extends EndpointFluentImpl<ServiceMonitorSpecFluent.EndpointsNested<N>> implements ServiceMonitorSpecFluent.EndpointsNested<N>,Nested<N>{
    EndpointsNestedImpl(Integer index,Endpoint item) {
      this.index = index;
      this.builder = new EndpointBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.index = -1;
      this.builder = new EndpointBuilder(this);
    }
    EndpointBuilder builder;
    Integer index;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<ServiceMonitorSpecFluent.NamespaceSelectorNested<N>> implements ServiceMonitorSpecFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new NamespaceSelectorBuilder(this);
    }
    NamespaceSelectorBuilder builder;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ServiceMonitorSpecFluent.SelectorNested<N>> implements ServiceMonitorSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}