package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ThanosRulerSpecBuilder extends ThanosRulerSpecFluentImpl<ThanosRulerSpecBuilder> implements VisitableBuilder<ThanosRulerSpec,ThanosRulerSpecBuilder>{
  public ThanosRulerSpecBuilder() {
    this(false);
  }
  public ThanosRulerSpecBuilder(Boolean validationEnabled) {
    this(new ThanosRulerSpec(), validationEnabled);
  }
  public ThanosRulerSpecBuilder(ThanosRulerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ThanosRulerSpecBuilder(ThanosRulerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ThanosRulerSpec(), validationEnabled);
  }
  public ThanosRulerSpecBuilder(ThanosRulerSpecFluent<?> fluent,ThanosRulerSpec instance) {
    this(fluent, instance, false);
  }
  public ThanosRulerSpecBuilder(ThanosRulerSpecFluent<?> fluent,ThanosRulerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAffinity(instance.getAffinity()); 
    fluent.withAlertDropLabels(instance.getAlertDropLabels()); 
    fluent.withAlertQueryUrl(instance.getAlertQueryUrl()); 
    fluent.withAlertRelabelConfigFile(instance.getAlertRelabelConfigFile()); 
    fluent.withAlertRelabelConfigs(instance.getAlertRelabelConfigs()); 
    fluent.withAlertmanagersConfig(instance.getAlertmanagersConfig()); 
    fluent.withAlertmanagersUrl(instance.getAlertmanagersUrl()); 
    fluent.withContainers(instance.getContainers()); 
    fluent.withEnforcedNamespaceLabel(instance.getEnforcedNamespaceLabel()); 
    fluent.withEvaluationInterval(instance.getEvaluationInterval()); 
    fluent.withExternalPrefix(instance.getExternalPrefix()); 
    fluent.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
    fluent.withImage(instance.getImage()); 
    fluent.withImagePullSecrets(instance.getImagePullSecrets()); 
    fluent.withInitContainers(instance.getInitContainers()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withListenLocal(instance.getListenLocal()); 
    fluent.withLogFormat(instance.getLogFormat()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withObjectStorageConfig(instance.getObjectStorageConfig()); 
    fluent.withObjectStorageConfigFile(instance.getObjectStorageConfigFile()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withPodMetadata(instance.getPodMetadata()); 
    fluent.withPortName(instance.getPortName()); 
    fluent.withPriorityClassName(instance.getPriorityClassName()); 
    fluent.withPrometheusRulesExcludedFromEnforce(instance.getPrometheusRulesExcludedFromEnforce()); 
    fluent.withQueryConfig(instance.getQueryConfig()); 
    fluent.withQueryEndpoints(instance.getQueryEndpoints()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withResources(instance.getResources()); 
    fluent.withRetention(instance.getRetention()); 
    fluent.withRoutePrefix(instance.getRoutePrefix()); 
    fluent.withRuleNamespaceSelector(instance.getRuleNamespaceSelector()); 
    fluent.withRuleSelector(instance.getRuleSelector()); 
    fluent.withSecurityContext(instance.getSecurityContext()); 
    fluent.withServiceAccountName(instance.getServiceAccountName()); 
    fluent.withStorage(instance.getStorage()); 
    fluent.withTolerations(instance.getTolerations()); 
    fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    fluent.withTracingConfig(instance.getTracingConfig()); 
    fluent.withVolumes(instance.getVolumes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ThanosRulerSpecBuilder(ThanosRulerSpec instance) {
    this(instance,false);
  }
  public ThanosRulerSpecBuilder(ThanosRulerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAffinity(instance.getAffinity()); 
    this.withAlertDropLabels(instance.getAlertDropLabels()); 
    this.withAlertQueryUrl(instance.getAlertQueryUrl()); 
    this.withAlertRelabelConfigFile(instance.getAlertRelabelConfigFile()); 
    this.withAlertRelabelConfigs(instance.getAlertRelabelConfigs()); 
    this.withAlertmanagersConfig(instance.getAlertmanagersConfig()); 
    this.withAlertmanagersUrl(instance.getAlertmanagersUrl()); 
    this.withContainers(instance.getContainers()); 
    this.withEnforcedNamespaceLabel(instance.getEnforcedNamespaceLabel()); 
    this.withEvaluationInterval(instance.getEvaluationInterval()); 
    this.withExternalPrefix(instance.getExternalPrefix()); 
    this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
    this.withImage(instance.getImage()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withLabels(instance.getLabels()); 
    this.withListenLocal(instance.getListenLocal()); 
    this.withLogFormat(instance.getLogFormat()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withObjectStorageConfig(instance.getObjectStorageConfig()); 
    this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile()); 
    this.withPaused(instance.getPaused()); 
    this.withPodMetadata(instance.getPodMetadata()); 
    this.withPortName(instance.getPortName()); 
    this.withPriorityClassName(instance.getPriorityClassName()); 
    this.withPrometheusRulesExcludedFromEnforce(instance.getPrometheusRulesExcludedFromEnforce()); 
    this.withQueryConfig(instance.getQueryConfig()); 
    this.withQueryEndpoints(instance.getQueryEndpoints()); 
    this.withReplicas(instance.getReplicas()); 
    this.withResources(instance.getResources()); 
    this.withRetention(instance.getRetention()); 
    this.withRoutePrefix(instance.getRoutePrefix()); 
    this.withRuleNamespaceSelector(instance.getRuleNamespaceSelector()); 
    this.withRuleSelector(instance.getRuleSelector()); 
    this.withSecurityContext(instance.getSecurityContext()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withStorage(instance.getStorage()); 
    this.withTolerations(instance.getTolerations()); 
    this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    this.withTracingConfig(instance.getTracingConfig()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ThanosRulerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ThanosRulerSpec build() {
    ThanosRulerSpec buildable = new ThanosRulerSpec(fluent.getAffinity(),fluent.getAlertDropLabels(),fluent.getAlertQueryUrl(),fluent.getAlertRelabelConfigFile(),fluent.getAlertRelabelConfigs(),fluent.getAlertmanagersConfig(),fluent.getAlertmanagersUrl(),fluent.getContainers(),fluent.getEnforcedNamespaceLabel(),fluent.getEvaluationInterval(),fluent.getExternalPrefix(),fluent.getGrpcServerTlsConfig(),fluent.getImage(),fluent.getImagePullSecrets(),fluent.getInitContainers(),fluent.getLabels(),fluent.getListenLocal(),fluent.getLogFormat(),fluent.getLogLevel(),fluent.getMinReadySeconds(),fluent.getNodeSelector(),fluent.getObjectStorageConfig(),fluent.getObjectStorageConfigFile(),fluent.getPaused(),fluent.getPodMetadata(),fluent.getPortName(),fluent.getPriorityClassName(),fluent.getPrometheusRulesExcludedFromEnforce(),fluent.getQueryConfig(),fluent.getQueryEndpoints(),fluent.getReplicas(),fluent.getResources(),fluent.getRetention(),fluent.getRoutePrefix(),fluent.getRuleNamespaceSelector(),fluent.getRuleSelector(),fluent.getSecurityContext(),fluent.getServiceAccountName(),fluent.getStorage(),fluent.getTolerations(),fluent.getTopologySpreadConstraints(),fluent.getTracingConfig(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}