package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PagerDutyConfigFluentImpl<A extends PagerDutyConfigFluent<A>> extends BaseFluent<A> implements PagerDutyConfigFluent<A>{
  public PagerDutyConfigFluentImpl() {
  }
  public PagerDutyConfigFluentImpl(PagerDutyConfig instance) {
    this.withClassName(instance.getClassName()); 
    this.withClient(instance.getClient()); 
    this.withClientURL(instance.getClientURL()); 
    this.withComponent(instance.getComponent()); 
    this.withDescription(instance.getDescription()); 
    this.withDetails(instance.getDetails()); 
    this.withGroup(instance.getGroup()); 
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withRoutingKey(instance.getRoutingKey()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withServiceKey(instance.getServiceKey()); 
    this.withSeverity(instance.getSeverity()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String className;
  private String client;
  private String clientURL;
  private String component;
  private String description;
  private ArrayList<KeyValueBuilder> details = new ArrayList<KeyValueBuilder>();
  private String group;
  private HTTPConfigBuilder httpConfig;
  private SecretKeySelector routingKey;
  private Boolean sendResolved;
  private SecretKeySelector serviceKey;
  private String severity;
  private String url;
  private Map<String,Object> additionalProperties;
  public String getClassName() {
    return this.className;
  }
  public A withClassName(String className) {
    this.className=className; return (A) this;
  }
  public Boolean hasClassName() {
    return this.className != null;
  }
  public String getClient() {
    return this.client;
  }
  public A withClient(String client) {
    this.client=client; return (A) this;
  }
  public Boolean hasClient() {
    return this.client != null;
  }
  public String getClientURL() {
    return this.clientURL;
  }
  public A withClientURL(String clientURL) {
    this.clientURL=clientURL; return (A) this;
  }
  public Boolean hasClientURL() {
    return this.clientURL != null;
  }
  public String getComponent() {
    return this.component;
  }
  public A withComponent(String component) {
    this.component=component; return (A) this;
  }
  public Boolean hasComponent() {
    return this.component != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public A addToDetails(Integer index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(index >= 0 ? index : _visitables.get("details").size(), builder);this.details.add(index >= 0 ? index : details.size(), builder); return (A)this;
  }
  public A setToDetails(Integer index,KeyValue item) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    KeyValueBuilder builder = new KeyValueBuilder(item);
    if (index < 0 || index >= _visitables.get("details").size()) { _visitables.get("details").add(builder); } else { _visitables.get("details").set(index, builder);}
    if (index < 0 || index >= details.size()) { details.add(builder); } else { details.set(index, builder);}
     return (A)this;
  }
  public A addToDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A addAllToDetails(Collection<KeyValue> items) {
    if (this.details == null) {this.details = new ArrayList<KeyValueBuilder>();}
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
  }
  public A removeFromDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeAllFromDetails(Collection<KeyValue> items) {
    for (KeyValue item : items) {KeyValueBuilder builder = new KeyValueBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDetails(Predicate<KeyValueBuilder> predicate) {
    if (details == null) return (A) this;
    final Iterator<KeyValueBuilder> each = details.iterator();
    final List visitables = _visitables.get("details");
    while (each.hasNext()) {
      KeyValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDetails instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KeyValue> getDetails() {
    return details != null ? build(details) : null;
  }
  public List<KeyValue> buildDetails() {
    return details != null ? build(details) : null;
  }
  public KeyValue buildDetail(Integer index) {
    return this.details.get(index).build();
  }
  public KeyValue buildFirstDetail() {
    return this.details.get(0).build();
  }
  public KeyValue buildLastDetail() {
    return this.details.get(details.size() - 1).build();
  }
  public KeyValue buildMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: details) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    for (KeyValueBuilder item: details) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDetails(List<KeyValue> details) {
    if (this.details != null) { _visitables.get("details").removeAll(this.details);}
    if (details != null) {this.details = new ArrayList(); for (KeyValue item : details){this.addToDetails(item);}} else { this.details = null;} return (A) this;
  }
  public A withDetails(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... details) {
    if (this.details != null) {this.details.clear();}
    if (details != null) {for (KeyValue item :details){ this.addToDetails(item);}} return (A) this;
  }
  public Boolean hasDetails() {
    return details != null && !details.isEmpty();
  }
  public A addNewDetail(String key,String value) {
    return (A)addToDetails(new KeyValue(key, value));
  }
  public PagerDutyConfigFluent.DetailsNested<A> addNewDetail() {
    return new PagerDutyConfigFluentImpl.DetailsNestedImpl();
  }
  public PagerDutyConfigFluent.DetailsNested<A> addNewDetailLike(KeyValue item) {
    return new PagerDutyConfigFluentImpl.DetailsNestedImpl(-1, item);
  }
  public PagerDutyConfigFluent.DetailsNested<A> setNewDetailLike(Integer index,KeyValue item) {
    return new PagerDutyConfigFluentImpl.DetailsNestedImpl(index, item);
  }
  public PagerDutyConfigFluent.DetailsNested<A> editDetail(Integer index) {
    if (details.size() <= index) throw new RuntimeException("Can't edit details. Index exceeds size.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public PagerDutyConfigFluent.DetailsNested<A> editFirstDetail() {
    if (details.size() == 0) throw new RuntimeException("Can't edit first details. The list is empty.");
    return setNewDetailLike(0, buildDetail(0));
  }
  public PagerDutyConfigFluent.DetailsNested<A> editLastDetail() {
    int index = details.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last details. The list is empty.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public PagerDutyConfigFluent.DetailsNested<A> editMatchingDetail(Predicate<KeyValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<details.size();i++) { 
    if (predicate.test(details.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching details. No match found.");
    return setNewDetailLike(index, buildDetail(index));
  }
  public String getGroup() {
    return this.group;
  }
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  public Boolean hasGroup() {
    return this.group != null;
  }
  
  /**
   * This method has been deprecated, please use method buildHttpConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPConfig getHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public A withHttpConfig(HTTPConfig httpConfig) {
    _visitables.get("httpConfig").remove(this.httpConfig);
    if (httpConfig!=null){ this.httpConfig= new HTTPConfigBuilder(httpConfig); _visitables.get("httpConfig").add(this.httpConfig);} else { this.httpConfig = null; _visitables.get("httpConfig").remove(this.httpConfig); } return (A) this;
  }
  public Boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  public PagerDutyConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
    return new PagerDutyConfigFluentImpl.HttpConfigNestedImpl();
  }
  public PagerDutyConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new PagerDutyConfigFluentImpl.HttpConfigNestedImpl(item);
  }
  public PagerDutyConfigFluent.HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig());
  }
  public PagerDutyConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): new HTTPConfigBuilder().build());
  }
  public PagerDutyConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): item);
  }
  public SecretKeySelector getRoutingKey() {
    return this.routingKey;
  }
  public A withRoutingKey(SecretKeySelector routingKey) {
    this.routingKey=routingKey; return (A) this;
  }
  public Boolean hasRoutingKey() {
    return this.routingKey != null;
  }
  public A withNewRoutingKey(String key,String name,Boolean optional) {
    return (A)withRoutingKey(new SecretKeySelector(key, name, optional));
  }
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved=sendResolved; return (A) this;
  }
  public Boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  public SecretKeySelector getServiceKey() {
    return this.serviceKey;
  }
  public A withServiceKey(SecretKeySelector serviceKey) {
    this.serviceKey=serviceKey; return (A) this;
  }
  public Boolean hasServiceKey() {
    return this.serviceKey != null;
  }
  public A withNewServiceKey(String key,String name,Boolean optional) {
    return (A)withServiceKey(new SecretKeySelector(key, name, optional));
  }
  public String getSeverity() {
    return this.severity;
  }
  public A withSeverity(String severity) {
    this.severity=severity; return (A) this;
  }
  public Boolean hasSeverity() {
    return this.severity != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PagerDutyConfigFluentImpl that = (PagerDutyConfigFluentImpl) o;
    if (className != null ? !className.equals(that.className) :that.className != null) return false;
    if (client != null ? !client.equals(that.client) :that.client != null) return false;
    if (clientURL != null ? !clientURL.equals(that.clientURL) :that.clientURL != null) return false;
    if (component != null ? !component.equals(that.component) :that.component != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (details != null ? !details.equals(that.details) :that.details != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (httpConfig != null ? !httpConfig.equals(that.httpConfig) :that.httpConfig != null) return false;
    if (routingKey != null ? !routingKey.equals(that.routingKey) :that.routingKey != null) return false;
    if (sendResolved != null ? !sendResolved.equals(that.sendResolved) :that.sendResolved != null) return false;
    if (serviceKey != null ? !serviceKey.equals(that.serviceKey) :that.serviceKey != null) return false;
    if (severity != null ? !severity.equals(that.severity) :that.severity != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(className,  client,  clientURL,  component,  description,  details,  group,  httpConfig,  routingKey,  sendResolved,  serviceKey,  severity,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (className != null) { sb.append("className:"); sb.append(className + ","); }
    if (client != null) { sb.append("client:"); sb.append(client + ","); }
    if (clientURL != null) { sb.append("clientURL:"); sb.append(clientURL + ","); }
    if (component != null) { sb.append("component:"); sb.append(component + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (details != null && !details.isEmpty()) { sb.append("details:"); sb.append(details + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (routingKey != null) { sb.append("routingKey:"); sb.append(routingKey + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (serviceKey != null) { sb.append("serviceKey:"); sb.append(serviceKey + ","); }
    if (severity != null) { sb.append("severity:"); sb.append(severity + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSendResolved() {
    return withSendResolved(true);
  }
  class DetailsNestedImpl<N> extends KeyValueFluentImpl<PagerDutyConfigFluent.DetailsNested<N>> implements PagerDutyConfigFluent.DetailsNested<N>,Nested<N>{
    DetailsNestedImpl(Integer index,KeyValue item) {
      this.index = index;
      this.builder = new KeyValueBuilder(this, item);
    }
    DetailsNestedImpl() {
      this.index = -1;
      this.builder = new KeyValueBuilder(this);
    }
    KeyValueBuilder builder;
    Integer index;
    public N and() {
      return (N) PagerDutyConfigFluentImpl.this.setToDetails(index,builder.build());
    }
    public N endDetail() {
      return and();
    }
    
  }
  class HttpConfigNestedImpl<N> extends HTTPConfigFluentImpl<PagerDutyConfigFluent.HttpConfigNested<N>> implements PagerDutyConfigFluent.HttpConfigNested<N>,Nested<N>{
    HttpConfigNestedImpl(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HttpConfigNestedImpl() {
      this.builder = new HTTPConfigBuilder(this);
    }
    HTTPConfigBuilder builder;
    public N and() {
      return (N) PagerDutyConfigFluentImpl.this.withHttpConfig(builder.build());
    }
    public N endHttpConfig() {
      return and();
    }
    
  }
  
}