package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RouteFluentImpl<A extends RouteFluent<A>> extends BaseFluent<A> implements RouteFluent<A>{
  public RouteFluentImpl() {
  }
  public RouteFluentImpl(Route instance) {
    this.withContinue(instance.getContinue()); 
    this.withGroupBy(instance.getGroupBy()); 
    this.withGroupInterval(instance.getGroupInterval()); 
    this.withGroupWait(instance.getGroupWait()); 
    this.withMatchers(instance.getMatchers()); 
    this.withReceiver(instance.getReceiver()); 
    this.withRepeatInterval(instance.getRepeatInterval()); 
    this.withRoutes(instance.getRoutes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean _continue;
  private List<String> groupBy = new ArrayList<String>();
  private String groupInterval;
  private String groupWait;
  private ArrayList<MatcherBuilder> matchers = new ArrayList<MatcherBuilder>();
  private String receiver;
  private String repeatInterval;
  private List<JsonNode> routes = new ArrayList<JsonNode>();
  private Map<String,Object> additionalProperties;
  public Boolean getContinue() {
    return this._continue;
  }
  public A withContinue(Boolean _continue) {
    this._continue=_continue; return (A) this;
  }
  public Boolean hasContinue() {
    return this._continue != null;
  }
  public A addToGroupBy(Integer index,String item) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    this.groupBy.add(index, item);
    return (A)this;
  }
  public A setToGroupBy(Integer index,String item) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    this.groupBy.set(index, item); return (A)this;
  }
  public A addToGroupBy(java.lang.String... items) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    for (String item : items) {this.groupBy.add(item);} return (A)this;
  }
  public A addAllToGroupBy(Collection<String> items) {
    if (this.groupBy == null) {this.groupBy = new ArrayList<String>();}
    for (String item : items) {this.groupBy.add(item);} return (A)this;
  }
  public A removeFromGroupBy(java.lang.String... items) {
    for (String item : items) {if (this.groupBy!= null){ this.groupBy.remove(item);}} return (A)this;
  }
  public A removeAllFromGroupBy(Collection<String> items) {
    for (String item : items) {if (this.groupBy!= null){ this.groupBy.remove(item);}} return (A)this;
  }
  public List<String> getGroupBy() {
    return this.groupBy;
  }
  public String getGroupBy(Integer index) {
    return this.groupBy.get(index);
  }
  public String getFirstGroupBy() {
    return this.groupBy.get(0);
  }
  public String getLastGroupBy() {
    return this.groupBy.get(groupBy.size() - 1);
  }
  public String getMatchingGroupBy(Predicate<String> predicate) {
    for (String item: groupBy) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroupBy(Predicate<String> predicate) {
    for (String item: groupBy) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroupBy(List<String> groupBy) {
    if (groupBy != null) {this.groupBy = new ArrayList(); for (String item : groupBy){this.addToGroupBy(item);}} else { this.groupBy = null;} return (A) this;
  }
  public A withGroupBy(java.lang.String... groupBy) {
    if (this.groupBy != null) {this.groupBy.clear();}
    if (groupBy != null) {for (String item :groupBy){ this.addToGroupBy(item);}} return (A) this;
  }
  public Boolean hasGroupBy() {
    return groupBy != null && !groupBy.isEmpty();
  }
  public String getGroupInterval() {
    return this.groupInterval;
  }
  public A withGroupInterval(String groupInterval) {
    this.groupInterval=groupInterval; return (A) this;
  }
  public Boolean hasGroupInterval() {
    return this.groupInterval != null;
  }
  public String getGroupWait() {
    return this.groupWait;
  }
  public A withGroupWait(String groupWait) {
    this.groupWait=groupWait; return (A) this;
  }
  public Boolean hasGroupWait() {
    return this.groupWait != null;
  }
  public A addToMatchers(Integer index,Matcher item) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").add(index >= 0 ? index : _visitables.get("matchers").size(), builder);this.matchers.add(index >= 0 ? index : matchers.size(), builder); return (A)this;
  }
  public A setToMatchers(Integer index,Matcher item) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= _visitables.get("matchers").size()) { _visitables.get("matchers").add(builder); } else { _visitables.get("matchers").set(index, builder);}
    if (index < 0 || index >= matchers.size()) { matchers.add(builder); } else { matchers.set(index, builder);}
     return (A)this;
  }
  public A addToMatchers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").add(builder);this.matchers.add(builder);} return (A)this;
  }
  public A addAllToMatchers(Collection<Matcher> items) {
    if (this.matchers == null) {this.matchers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").add(builder);this.matchers.add(builder);} return (A)this;
  }
  public A removeFromMatchers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").remove(builder);if (this.matchers != null) {this.matchers.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatchers(Collection<Matcher> items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("matchers").remove(builder);if (this.matchers != null) {this.matchers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatchers(Predicate<MatcherBuilder> predicate) {
    if (matchers == null) return (A) this;
    final Iterator<MatcherBuilder> each = matchers.iterator();
    final List visitables = _visitables.get("matchers");
    while (each.hasNext()) {
      MatcherBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Matcher> getMatchers() {
    return matchers != null ? build(matchers) : null;
  }
  public List<Matcher> buildMatchers() {
    return matchers != null ? build(matchers) : null;
  }
  public Matcher buildMatcher(Integer index) {
    return this.matchers.get(index).build();
  }
  public Matcher buildFirstMatcher() {
    return this.matchers.get(0).build();
  }
  public Matcher buildLastMatcher() {
    return this.matchers.get(matchers.size() - 1).build();
  }
  public Matcher buildMatchingMatcher(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: matchers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatcher(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: matchers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchers(List<Matcher> matchers) {
    if (this.matchers != null) { _visitables.get("matchers").removeAll(this.matchers);}
    if (matchers != null) {this.matchers = new ArrayList(); for (Matcher item : matchers){this.addToMatchers(item);}} else { this.matchers = null;} return (A) this;
  }
  public A withMatchers(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... matchers) {
    if (this.matchers != null) {this.matchers.clear();}
    if (matchers != null) {for (Matcher item :matchers){ this.addToMatchers(item);}} return (A) this;
  }
  public Boolean hasMatchers() {
    return matchers != null && !matchers.isEmpty();
  }
  public A addNewMatcher(String name,Boolean regex,String value) {
    return (A)addToMatchers(new Matcher(name, regex, value));
  }
  public RouteFluent.MatchersNested<A> addNewMatcher() {
    return new RouteFluentImpl.MatchersNestedImpl();
  }
  public RouteFluent.MatchersNested<A> addNewMatcherLike(Matcher item) {
    return new RouteFluentImpl.MatchersNestedImpl(-1, item);
  }
  public RouteFluent.MatchersNested<A> setNewMatcherLike(Integer index,Matcher item) {
    return new RouteFluentImpl.MatchersNestedImpl(index, item);
  }
  public RouteFluent.MatchersNested<A> editMatcher(Integer index) {
    if (matchers.size() <= index) throw new RuntimeException("Can't edit matchers. Index exceeds size.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  public RouteFluent.MatchersNested<A> editFirstMatcher() {
    if (matchers.size() == 0) throw new RuntimeException("Can't edit first matchers. The list is empty.");
    return setNewMatcherLike(0, buildMatcher(0));
  }
  public RouteFluent.MatchersNested<A> editLastMatcher() {
    int index = matchers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchers. The list is empty.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  public RouteFluent.MatchersNested<A> editMatchingMatcher(Predicate<MatcherBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchers.size();i++) { 
    if (predicate.test(matchers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchers. No match found.");
    return setNewMatcherLike(index, buildMatcher(index));
  }
  public String getReceiver() {
    return this.receiver;
  }
  public A withReceiver(String receiver) {
    this.receiver=receiver; return (A) this;
  }
  public Boolean hasReceiver() {
    return this.receiver != null;
  }
  public String getRepeatInterval() {
    return this.repeatInterval;
  }
  public A withRepeatInterval(String repeatInterval) {
    this.repeatInterval=repeatInterval; return (A) this;
  }
  public Boolean hasRepeatInterval() {
    return this.repeatInterval != null;
  }
  public A addToRoutes(Integer index,JsonNode item) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    this.routes.add(index, item);
    return (A)this;
  }
  public A setToRoutes(Integer index,JsonNode item) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    this.routes.set(index, item); return (A)this;
  }
  public A addToRoutes(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.routes.add(item);} return (A)this;
  }
  public A addAllToRoutes(Collection<JsonNode> items) {
    if (this.routes == null) {this.routes = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.routes.add(item);} return (A)this;
  }
  public A removeFromRoutes(com.fasterxml.jackson.databind.JsonNode... items) {
    for (JsonNode item : items) {if (this.routes!= null){ this.routes.remove(item);}} return (A)this;
  }
  public A removeAllFromRoutes(Collection<JsonNode> items) {
    for (JsonNode item : items) {if (this.routes!= null){ this.routes.remove(item);}} return (A)this;
  }
  public List<JsonNode> getRoutes() {
    return this.routes;
  }
  public JsonNode getRoute(Integer index) {
    return this.routes.get(index);
  }
  public JsonNode getFirstRoute() {
    return this.routes.get(0);
  }
  public JsonNode getLastRoute() {
    return this.routes.get(routes.size() - 1);
  }
  public JsonNode getMatchingRoute(Predicate<JsonNode> predicate) {
    for (JsonNode item: routes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRoute(Predicate<JsonNode> predicate) {
    for (JsonNode item: routes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoutes(List<JsonNode> routes) {
    if (routes != null) {this.routes = new ArrayList(); for (JsonNode item : routes){this.addToRoutes(item);}} else { this.routes = null;} return (A) this;
  }
  public A withRoutes(com.fasterxml.jackson.databind.JsonNode... routes) {
    if (this.routes != null) {this.routes.clear();}
    if (routes != null) {for (JsonNode item :routes){ this.addToRoutes(item);}} return (A) this;
  }
  public Boolean hasRoutes() {
    return routes != null && !routes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouteFluentImpl that = (RouteFluentImpl) o;
    if (_continue != null ? !_continue.equals(that._continue) :that._continue != null) return false;
    if (groupBy != null ? !groupBy.equals(that.groupBy) :that.groupBy != null) return false;
    if (groupInterval != null ? !groupInterval.equals(that.groupInterval) :that.groupInterval != null) return false;
    if (groupWait != null ? !groupWait.equals(that.groupWait) :that.groupWait != null) return false;
    if (matchers != null ? !matchers.equals(that.matchers) :that.matchers != null) return false;
    if (receiver != null ? !receiver.equals(that.receiver) :that.receiver != null) return false;
    if (repeatInterval != null ? !repeatInterval.equals(that.repeatInterval) :that.repeatInterval != null) return false;
    if (routes != null ? !routes.equals(that.routes) :that.routes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(_continue,  groupBy,  groupInterval,  groupWait,  matchers,  receiver,  repeatInterval,  routes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (_continue != null) { sb.append("_continue:"); sb.append(_continue + ","); }
    if (groupBy != null && !groupBy.isEmpty()) { sb.append("groupBy:"); sb.append(groupBy + ","); }
    if (groupInterval != null) { sb.append("groupInterval:"); sb.append(groupInterval + ","); }
    if (groupWait != null) { sb.append("groupWait:"); sb.append(groupWait + ","); }
    if (matchers != null && !matchers.isEmpty()) { sb.append("matchers:"); sb.append(matchers + ","); }
    if (receiver != null) { sb.append("receiver:"); sb.append(receiver + ","); }
    if (repeatInterval != null) { sb.append("repeatInterval:"); sb.append(repeatInterval + ","); }
    if (routes != null && !routes.isEmpty()) { sb.append("routes:"); sb.append(routes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withContinue() {
    return withContinue(true);
  }
  class MatchersNestedImpl<N> extends MatcherFluentImpl<RouteFluent.MatchersNested<N>> implements RouteFluent.MatchersNested<N>,Nested<N>{
    MatchersNestedImpl(Integer index,Matcher item) {
      this.index = index;
      this.builder = new MatcherBuilder(this, item);
    }
    MatchersNestedImpl() {
      this.index = -1;
      this.builder = new MatcherBuilder(this);
    }
    MatcherBuilder builder;
    Integer index;
    public N and() {
      return (N) RouteFluentImpl.this.setToMatchers(index,builder.build());
    }
    public N endMatcher() {
      return and();
    }
    
  }
  
}