package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodMonitorListBuilder extends PodMonitorListFluentImpl<PodMonitorListBuilder> implements VisitableBuilder<PodMonitorList,PodMonitorListBuilder>{
  public PodMonitorListBuilder() {
    this(false);
  }
  public PodMonitorListBuilder(Boolean validationEnabled) {
    this(new PodMonitorList(), validationEnabled);
  }
  public PodMonitorListBuilder(PodMonitorListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodMonitorListBuilder(PodMonitorListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodMonitorList(), validationEnabled);
  }
  public PodMonitorListBuilder(PodMonitorListFluent<?> fluent,PodMonitorList instance) {
    this(fluent, instance, false);
  }
  public PodMonitorListBuilder(PodMonitorListFluent<?> fluent,PodMonitorList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodMonitorListBuilder(PodMonitorList instance) {
    this(instance,false);
  }
  public PodMonitorListBuilder(PodMonitorList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodMonitorListFluent<?> fluent;
  Boolean validationEnabled;
  public PodMonitorList build() {
    PodMonitorList buildable = new PodMonitorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}