package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusRuleExcludeConfigBuilder extends PrometheusRuleExcludeConfigFluentImpl<PrometheusRuleExcludeConfigBuilder> implements VisitableBuilder<PrometheusRuleExcludeConfig,PrometheusRuleExcludeConfigBuilder>{
  public PrometheusRuleExcludeConfigBuilder() {
    this(false);
  }
  public PrometheusRuleExcludeConfigBuilder(Boolean validationEnabled) {
    this(new PrometheusRuleExcludeConfig(), validationEnabled);
  }
  public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrometheusRuleExcludeConfig(), validationEnabled);
  }
  public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent,PrometheusRuleExcludeConfig instance) {
    this(fluent, instance, false);
  }
  public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfigFluent<?> fluent,PrometheusRuleExcludeConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRuleName(instance.getRuleName());
      fluent.withRuleNamespace(instance.getRuleNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfig instance) {
    this(instance,false);
  }
  public PrometheusRuleExcludeConfigBuilder(PrometheusRuleExcludeConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRuleName(instance.getRuleName());
      this.withRuleNamespace(instance.getRuleNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrometheusRuleExcludeConfigFluent<?> fluent;
  Boolean validationEnabled;
  public PrometheusRuleExcludeConfig build() {
    PrometheusRuleExcludeConfig buildable = new PrometheusRuleExcludeConfig(fluent.getRuleName(),fluent.getRuleNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}