package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RemoteReadSpecFluentImpl<A extends RemoteReadSpecFluent<A>> extends BaseFluent<A> implements RemoteReadSpecFluent<A>{
  public RemoteReadSpecFluentImpl() {
  }
  public RemoteReadSpecFluentImpl(RemoteReadSpec instance) {
    if (instance != null) {
      this.withAuthorization(instance.getAuthorization());
      this.withBasicAuth(instance.getBasicAuth());
      this.withBearerToken(instance.getBearerToken());
      this.withBearerTokenFile(instance.getBearerTokenFile());
      this.withName(instance.getName());
      this.withOauth2(instance.getOauth2());
      this.withProxyUrl(instance.getProxyUrl());
      this.withReadRecent(instance.getReadRecent());
      this.withRemoteTimeout(instance.getRemoteTimeout());
      this.withRequiredMatchers(instance.getRequiredMatchers());
      this.withTlsConfig(instance.getTlsConfig());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private String bearerToken;
  private String bearerTokenFile;
  private String name;
  private OAuth2Builder oauth2;
  private String proxyUrl;
  private Boolean readRecent;
  private String remoteTimeout;
  private Map<String,String> requiredMatchers;
  private TLSConfigBuilder tlsConfig;
  private String url;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public Authorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public Authorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(Authorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new AuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public RemoteReadSpecFluentImpl.AuthorizationNested<A> withNewAuthorization() {
    return new RemoteReadSpecFluentImpl.AuthorizationNestedImpl();
  }
  public RemoteReadSpecFluentImpl.AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
    return new RemoteReadSpecFluentImpl.AuthorizationNestedImpl(item);
  }
  public RemoteReadSpecFluentImpl.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public RemoteReadSpecFluentImpl.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new AuthorizationBuilder().build());
  }
  public RemoteReadSpecFluentImpl.AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public RemoteReadSpecFluentImpl.BasicAuthNested<A> withNewBasicAuth() {
    return new RemoteReadSpecFluentImpl.BasicAuthNestedImpl();
  }
  public RemoteReadSpecFluentImpl.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new RemoteReadSpecFluentImpl.BasicAuthNestedImpl(item);
  }
  public RemoteReadSpecFluentImpl.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public RemoteReadSpecFluentImpl.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
  }
  public RemoteReadSpecFluentImpl.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public String getBearerToken() {
    return this.bearerToken;
  }
  public A withBearerToken(String bearerToken) {
    this.bearerToken=bearerToken; return (A) this;
  }
  public Boolean hasBearerToken() {
    return this.bearerToken != null;
  }
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile=bearerTokenFile; return (A) this;
  }
  public Boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOauth2 instead.
   * @return The buildable object.
   */
  @Deprecated
  public OAuth2 getOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public OAuth2 buildOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public A withOauth2(OAuth2 oauth2) {
    _visitables.get("oauth2").remove(this.oauth2);
    if (oauth2!=null){ this.oauth2= new OAuth2Builder(oauth2); _visitables.get("oauth2").add(this.oauth2);} else { this.oauth2 = null; _visitables.get("oauth2").remove(this.oauth2); } return (A) this;
  }
  public Boolean hasOauth2() {
    return this.oauth2 != null;
  }
  public RemoteReadSpecFluentImpl.Oauth2Nested<A> withNewOauth2() {
    return new RemoteReadSpecFluentImpl.Oauth2NestedImpl();
  }
  public RemoteReadSpecFluentImpl.Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
    return new RemoteReadSpecFluentImpl.Oauth2NestedImpl(item);
  }
  public RemoteReadSpecFluentImpl.Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(getOauth2());
  }
  public RemoteReadSpecFluentImpl.Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): new OAuth2Builder().build());
  }
  public RemoteReadSpecFluentImpl.Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): item);
  }
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public Boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  public Boolean getReadRecent() {
    return this.readRecent;
  }
  public A withReadRecent(Boolean readRecent) {
    this.readRecent=readRecent; return (A) this;
  }
  public Boolean hasReadRecent() {
    return this.readRecent != null;
  }
  public String getRemoteTimeout() {
    return this.remoteTimeout;
  }
  public A withRemoteTimeout(String remoteTimeout) {
    this.remoteTimeout=remoteTimeout; return (A) this;
  }
  public Boolean hasRemoteTimeout() {
    return this.remoteTimeout != null;
  }
  public A addToRequiredMatchers(String key,String value) {
    if(this.requiredMatchers == null && key != null && value != null) { this.requiredMatchers = new LinkedHashMap(); }
    if(key != null && value != null) {this.requiredMatchers.put(key, value);} return (A)this;
  }
  public A addToRequiredMatchers(Map<String,String> map) {
    if(this.requiredMatchers == null && map != null) { this.requiredMatchers = new LinkedHashMap(); }
    if(map != null) { this.requiredMatchers.putAll(map);} return (A)this;
  }
  public A removeFromRequiredMatchers(String key) {
    if(this.requiredMatchers == null) { return (A) this; }
    if(key != null && this.requiredMatchers != null) {this.requiredMatchers.remove(key);} return (A)this;
  }
  public A removeFromRequiredMatchers(Map<String,String> map) {
    if(this.requiredMatchers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.requiredMatchers != null){this.requiredMatchers.remove(key);}}} return (A)this;
  }
  public Map<String,String> getRequiredMatchers() {
    return this.requiredMatchers;
  }
  public <K,V>A withRequiredMatchers(Map<String,String> requiredMatchers) {
    if (requiredMatchers == null) { this.requiredMatchers =  null;} else {this.requiredMatchers = new LinkedHashMap(requiredMatchers);} return (A) this;
  }
  public Boolean hasRequiredMatchers() {
    return this.requiredMatchers != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(TLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} else { this.tlsConfig = null; _visitables.get("tlsConfig").remove(this.tlsConfig); } return (A) this;
  }
  public Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public RemoteReadSpecFluentImpl.TlsConfigNested<A> withNewTlsConfig() {
    return new RemoteReadSpecFluentImpl.TlsConfigNestedImpl();
  }
  public RemoteReadSpecFluentImpl.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new RemoteReadSpecFluentImpl.TlsConfigNestedImpl(item);
  }
  public RemoteReadSpecFluentImpl.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public RemoteReadSpecFluentImpl.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
  }
  public RemoteReadSpecFluentImpl.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RemoteReadSpecFluentImpl that = (RemoteReadSpecFluentImpl) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;

    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;

    if (!java.util.Objects.equals(bearerToken, that.bearerToken)) return false;

    if (!java.util.Objects.equals(bearerTokenFile, that.bearerTokenFile)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(oauth2, that.oauth2)) return false;

    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;

    if (!java.util.Objects.equals(readRecent, that.readRecent)) return false;

    if (!java.util.Objects.equals(remoteTimeout, that.remoteTimeout)) return false;

    if (!java.util.Objects.equals(requiredMatchers, that.requiredMatchers)) return false;

    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerToken,  bearerTokenFile,  name,  oauth2,  proxyUrl,  readRecent,  remoteTimeout,  requiredMatchers,  tlsConfig,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerToken != null) { sb.append("bearerToken:"); sb.append(bearerToken + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (readRecent != null) { sb.append("readRecent:"); sb.append(readRecent + ","); }
    if (remoteTimeout != null) { sb.append("remoteTimeout:"); sb.append(remoteTimeout + ","); }
    if (requiredMatchers != null && !requiredMatchers.isEmpty()) { sb.append("requiredMatchers:"); sb.append(requiredMatchers + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withReadRecent() {
    return withReadRecent(true);
  }
  class AuthorizationNestedImpl<N> extends AuthorizationFluentImpl<RemoteReadSpecFluentImpl.AuthorizationNested<N>> implements RemoteReadSpecFluentImpl.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(Authorization item) {
      this.builder = new AuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new AuthorizationBuilder(this);
    }
    AuthorizationBuilder builder;
    public N and() {
      return (N) RemoteReadSpecFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<RemoteReadSpecFluentImpl.BasicAuthNested<N>> implements RemoteReadSpecFluentImpl.BasicAuthNested<N>,Nested<N>{
    BasicAuthNestedImpl(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new BasicAuthBuilder(this);
    }
    BasicAuthBuilder builder;
    public N and() {
      return (N) RemoteReadSpecFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class Oauth2NestedImpl<N> extends OAuth2FluentImpl<RemoteReadSpecFluentImpl.Oauth2Nested<N>> implements RemoteReadSpecFluentImpl.Oauth2Nested<N>,Nested<N>{
    Oauth2NestedImpl(OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    Oauth2NestedImpl() {
      this.builder = new OAuth2Builder(this);
    }
    OAuth2Builder builder;
    public N and() {
      return (N) RemoteReadSpecFluentImpl.this.withOauth2(builder.build());
    }
    public N endOauth2() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<RemoteReadSpecFluentImpl.TlsConfigNested<N>> implements RemoteReadSpecFluentImpl.TlsConfigNested<N>,Nested<N>{
    TlsConfigNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) RemoteReadSpecFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}