package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ThanosRulerStatusBuilder extends ThanosRulerStatusFluentImpl<ThanosRulerStatusBuilder> implements VisitableBuilder<ThanosRulerStatus,ThanosRulerStatusBuilder>{
  public ThanosRulerStatusBuilder() {
    this(false);
  }
  public ThanosRulerStatusBuilder(Boolean validationEnabled) {
    this(new ThanosRulerStatus(), validationEnabled);
  }
  public ThanosRulerStatusBuilder(ThanosRulerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ThanosRulerStatusBuilder(ThanosRulerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ThanosRulerStatus(), validationEnabled);
  }
  public ThanosRulerStatusBuilder(ThanosRulerStatusFluent<?> fluent,ThanosRulerStatus instance) {
    this(fluent, instance, false);
  }
  public ThanosRulerStatusBuilder(ThanosRulerStatusFluent<?> fluent,ThanosRulerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withPaused(instance.getPaused());
      fluent.withReplicas(instance.getReplicas());
      fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ThanosRulerStatusBuilder(ThanosRulerStatus instance) {
    this(instance,false);
  }
  public ThanosRulerStatusBuilder(ThanosRulerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withPaused(instance.getPaused());
      this.withReplicas(instance.getReplicas());
      this.withUnavailableReplicas(instance.getUnavailableReplicas());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ThanosRulerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ThanosRulerStatus build() {
    ThanosRulerStatus buildable = new ThanosRulerStatus(fluent.getAvailableReplicas(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}