package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureSDKBuilder extends AzureSDKFluent<AzureSDKBuilder> implements VisitableBuilder<AzureSDK,AzureSDKBuilder>{
  public AzureSDKBuilder() {
    this(new AzureSDK());
  }
  
  public AzureSDKBuilder(AzureSDKFluent<?> fluent) {
    this(fluent, new AzureSDK());
  }
  
  public AzureSDKBuilder(AzureSDKFluent<?> fluent,AzureSDK instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureSDKBuilder(AzureSDK instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureSDKFluent<?> fluent;
  
  public AzureSDK build() {
    AzureSDK buildable = new AzureSDK(fluent.getTenantId());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}