package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OTLPConfigBuilder extends OTLPConfigFluent<OTLPConfigBuilder> implements VisitableBuilder<OTLPConfig,OTLPConfigBuilder>{
  public OTLPConfigBuilder() {
    this(new OTLPConfig());
  }
  
  public OTLPConfigBuilder(OTLPConfigFluent<?> fluent) {
    this(fluent, new OTLPConfig());
  }
  
  public OTLPConfigBuilder(OTLPConfigFluent<?> fluent,OTLPConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OTLPConfigBuilder(OTLPConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OTLPConfigFluent<?> fluent;
  
  public OTLPConfig build() {
    OTLPConfig buildable = new OTLPConfig(fluent.getPromoteResourceAttributes(),fluent.getTranslationStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}