package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RuleGroupBuilder extends RuleGroupFluent<RuleGroupBuilder> implements VisitableBuilder<RuleGroup,RuleGroupBuilder>{
  public RuleGroupBuilder() {
    this(new RuleGroup());
  }
  
  public RuleGroupBuilder(RuleGroupFluent<?> fluent) {
    this(fluent, new RuleGroup());
  }
  
  public RuleGroupBuilder(RuleGroupFluent<?> fluent,RuleGroup instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RuleGroupBuilder(RuleGroup instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RuleGroupFluent<?> fluent;
  
  public RuleGroup build() {
    RuleGroup buildable = new RuleGroup(fluent.getInterval(),fluent.getLabels(),fluent.getLimit(),fluent.getName(),fluent.getPartialResponseStrategy(),fluent.getQueryOffset(),fluent.buildRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}