package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RulesAlertBuilder extends RulesAlertFluent<RulesAlertBuilder> implements VisitableBuilder<RulesAlert,RulesAlertBuilder>{
  public RulesAlertBuilder() {
    this(new RulesAlert());
  }
  
  public RulesAlertBuilder(RulesAlertFluent<?> fluent) {
    this(fluent, new RulesAlert());
  }
  
  public RulesAlertBuilder(RulesAlertFluent<?> fluent,RulesAlert instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RulesAlertBuilder(RulesAlert instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RulesAlertFluent<?> fluent;
  
  public RulesAlert build() {
    RulesAlert buildable = new RulesAlert(fluent.getForGracePeriod(),fluent.getForOutageTolerance(),fluent.getResendDelay());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}