package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OVHCloudSDConfigFluent<A extends OVHCloudSDConfigFluent<A>> extends BaseFluent<A>{
  public OVHCloudSDConfigFluent() {
  }
  
  public OVHCloudSDConfigFluent(OVHCloudSDConfig instance) {
    this.copyInstance(instance);
  }
  private String applicationKey;
  private SecretKeySelector applicationSecret;
  private SecretKeySelector consumerKey;
  private String endpoint;
  private String refreshInterval;
  private String service;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OVHCloudSDConfig instance) {
    instance = (instance != null ? instance : new OVHCloudSDConfig());
    if (instance != null) {
          this.withApplicationKey(instance.getApplicationKey());
          this.withApplicationSecret(instance.getApplicationSecret());
          this.withConsumerKey(instance.getConsumerKey());
          this.withEndpoint(instance.getEndpoint());
          this.withRefreshInterval(instance.getRefreshInterval());
          this.withService(instance.getService());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApplicationKey() {
    return this.applicationKey;
  }
  
  public A withApplicationKey(String applicationKey) {
    this.applicationKey = applicationKey;
    return (A) this;
  }
  
  public boolean hasApplicationKey() {
    return this.applicationKey != null;
  }
  
  public SecretKeySelector getApplicationSecret() {
    return this.applicationSecret;
  }
  
  public A withApplicationSecret(SecretKeySelector applicationSecret) {
    this.applicationSecret = applicationSecret;
    return (A) this;
  }
  
  public boolean hasApplicationSecret() {
    return this.applicationSecret != null;
  }
  
  public A withNewApplicationSecret(String key,String name,Boolean optional) {
    return (A)withApplicationSecret(new SecretKeySelector(key, name, optional));
  }
  
  public SecretKeySelector getConsumerKey() {
    return this.consumerKey;
  }
  
  public A withConsumerKey(SecretKeySelector consumerKey) {
    this.consumerKey = consumerKey;
    return (A) this;
  }
  
  public boolean hasConsumerKey() {
    return this.consumerKey != null;
  }
  
  public A withNewConsumerKey(String key,String name,Boolean optional) {
    return (A)withConsumerKey(new SecretKeySelector(key, name, optional));
  }
  
  public String getEndpoint() {
    return this.endpoint;
  }
  
  public A withEndpoint(String endpoint) {
    this.endpoint = endpoint;
    return (A) this;
  }
  
  public boolean hasEndpoint() {
    return this.endpoint != null;
  }
  
  public String getRefreshInterval() {
    return this.refreshInterval;
  }
  
  public A withRefreshInterval(String refreshInterval) {
    this.refreshInterval = refreshInterval;
    return (A) this;
  }
  
  public boolean hasRefreshInterval() {
    return this.refreshInterval != null;
  }
  
  public String getService() {
    return this.service;
  }
  
  public A withService(String service) {
    this.service = service;
    return (A) this;
  }
  
  public boolean hasService() {
    return this.service != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OVHCloudSDConfigFluent that = (OVHCloudSDConfigFluent) o;
    if (!java.util.Objects.equals(applicationKey, that.applicationKey)) return false;
    if (!java.util.Objects.equals(applicationSecret, that.applicationSecret)) return false;
    if (!java.util.Objects.equals(consumerKey, that.consumerKey)) return false;
    if (!java.util.Objects.equals(endpoint, that.endpoint)) return false;
    if (!java.util.Objects.equals(refreshInterval, that.refreshInterval)) return false;
    if (!java.util.Objects.equals(service, that.service)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(applicationKey,  applicationSecret,  consumerKey,  endpoint,  refreshInterval,  service,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applicationKey != null) { sb.append("applicationKey:"); sb.append(applicationKey + ","); }
    if (applicationSecret != null) { sb.append("applicationSecret:"); sb.append(applicationSecret + ","); }
    if (consumerKey != null) { sb.append("consumerKey:"); sb.append(consumerKey + ","); }
    if (endpoint != null) { sb.append("endpoint:"); sb.append(endpoint + ","); }
    if (refreshInterval != null) { sb.append("refreshInterval:"); sb.append(refreshInterval + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}