package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TimeIntervalBuilder extends TimeIntervalFluent<TimeIntervalBuilder> implements VisitableBuilder<TimeInterval,TimeIntervalBuilder>{
  public TimeIntervalBuilder() {
    this(new TimeInterval());
  }
  
  public TimeIntervalBuilder(TimeIntervalFluent<?> fluent) {
    this(fluent, new TimeInterval());
  }
  
  public TimeIntervalBuilder(TimeIntervalFluent<?> fluent,TimeInterval instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TimeIntervalBuilder(TimeInterval instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TimeIntervalFluent<?> fluent;
  
  public TimeInterval build() {
    TimeInterval buildable = new TimeInterval(fluent.getName(),fluent.buildTimeIntervals());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}