/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TLSConfigFluent<A extends TLSConfigFluent<A>>
extends BaseFluent<A> {
    private SecretOrConfigMapBuilder ca;
    private String caFile;
    private SecretOrConfigMapBuilder cert;
    private String certFile;
    private Boolean insecureSkipVerify;
    private String keyFile;
    private SecretKeySelector keySecret;
    private String maxVersion;
    private String minVersion;
    private String serverName;
    private Map<String, Object> additionalProperties;

    public TLSConfigFluent() {
    }

    public TLSConfigFluent(TLSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TLSConfig instance) {
        TLSConfig tLSConfig = instance = instance != null ? instance : new TLSConfig();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withCaFile(instance.getCaFile());
            this.withCert(instance.getCert());
            this.withCertFile(instance.getCertFile());
            this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
            this.withKeyFile(instance.getKeyFile());
            this.withKeySecret(instance.getKeySecret());
            this.withMaxVersion(instance.getMaxVersion());
            this.withMinVersion(instance.getMinVersion());
            this.withServerName(instance.getServerName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretOrConfigMap buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(SecretOrConfigMap ca) {
        this._visitables.remove((Object)"ca");
        if (ca != null) {
            this.ca = new SecretOrConfigMapBuilder(ca);
            this._visitables.get((Object)"ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get((Object)"ca").remove((Object)this.ca);
        }
        return (A)((Object)this);
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(SecretOrConfigMap item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(SecretOrConfigMap item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public String getCaFile() {
        return this.caFile;
    }

    public A withCaFile(String caFile) {
        this.caFile = caFile;
        return (A)((Object)this);
    }

    public boolean hasCaFile() {
        return this.caFile != null;
    }

    public SecretOrConfigMap buildCert() {
        return this.cert != null ? this.cert.build() : null;
    }

    public A withCert(SecretOrConfigMap cert) {
        this._visitables.remove((Object)"cert");
        if (cert != null) {
            this.cert = new SecretOrConfigMapBuilder(cert);
            this._visitables.get((Object)"cert").add(this.cert);
        } else {
            this.cert = null;
            this._visitables.get((Object)"cert").remove((Object)this.cert);
        }
        return (A)((Object)this);
    }

    public boolean hasCert() {
        return this.cert != null;
    }

    public CertNested<A> withNewCert() {
        return new CertNested(null);
    }

    public CertNested<A> withNewCertLike(SecretOrConfigMap item) {
        return new CertNested(item);
    }

    public CertNested<A> editCert() {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(null));
    }

    public CertNested<A> editOrNewCert() {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(new SecretOrConfigMapBuilder().build()));
    }

    public CertNested<A> editOrNewCertLike(SecretOrConfigMap item) {
        return this.withNewCertLike(Optional.ofNullable(this.buildCert()).orElse(item));
    }

    public String getCertFile() {
        return this.certFile;
    }

    public A withCertFile(String certFile) {
        this.certFile = certFile;
        return (A)((Object)this);
    }

    public boolean hasCertFile() {
        return this.certFile != null;
    }

    public Boolean getInsecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
        this.insecureSkipVerify = insecureSkipVerify;
        return (A)((Object)this);
    }

    public boolean hasInsecureSkipVerify() {
        return this.insecureSkipVerify != null;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public A withKeyFile(String keyFile) {
        this.keyFile = keyFile;
        return (A)((Object)this);
    }

    public boolean hasKeyFile() {
        return this.keyFile != null;
    }

    public SecretKeySelector getKeySecret() {
        return this.keySecret;
    }

    public A withKeySecret(SecretKeySelector keySecret) {
        this.keySecret = keySecret;
        return (A)((Object)this);
    }

    public boolean hasKeySecret() {
        return this.keySecret != null;
    }

    public A withNewKeySecret(String key, String name, Boolean optional) {
        return this.withKeySecret(new SecretKeySelector(key, name, optional));
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public A withMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
        return (A)((Object)this);
    }

    public boolean hasMaxVersion() {
        return this.maxVersion != null;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public A withMinVersion(String minVersion) {
        this.minVersion = minVersion;
        return (A)((Object)this);
    }

    public boolean hasMinVersion() {
        return this.minVersion != null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public A withServerName(String serverName) {
        this.serverName = serverName;
        return (A)((Object)this);
    }

    public boolean hasServerName() {
        return this.serverName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSConfigFluent that = (TLSConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.ca, (Object)that.ca)) {
            return false;
        }
        if (!Objects.equals(this.caFile, that.caFile)) {
            return false;
        }
        if (!Objects.equals((Object)this.cert, (Object)that.cert)) {
            return false;
        }
        if (!Objects.equals(this.certFile, that.certFile)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipVerify, that.insecureSkipVerify)) {
            return false;
        }
        if (!Objects.equals(this.keyFile, that.keyFile)) {
            return false;
        }
        if (!Objects.equals(this.keySecret, that.keySecret)) {
            return false;
        }
        if (!Objects.equals(this.maxVersion, that.maxVersion)) {
            return false;
        }
        if (!Objects.equals(this.minVersion, that.minVersion)) {
            return false;
        }
        if (!Objects.equals(this.serverName, that.serverName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ca, this.caFile, this.cert, this.certFile, this.insecureSkipVerify, this.keyFile, this.keySecret, this.maxVersion, this.minVersion, this.serverName, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.caFile != null) {
            sb.append("caFile:");
            sb.append(this.caFile + ",");
        }
        if (this.cert != null) {
            sb.append("cert:");
            sb.append(this.cert + ",");
        }
        if (this.certFile != null) {
            sb.append("certFile:");
            sb.append(this.certFile + ",");
        }
        if (this.insecureSkipVerify != null) {
            sb.append("insecureSkipVerify:");
            sb.append(this.insecureSkipVerify + ",");
        }
        if (this.keyFile != null) {
            sb.append("keyFile:");
            sb.append(this.keyFile + ",");
        }
        if (this.keySecret != null) {
            sb.append("keySecret:");
            sb.append(this.keySecret + ",");
        }
        if (this.maxVersion != null) {
            sb.append("maxVersion:");
            sb.append(this.maxVersion + ",");
        }
        if (this.minVersion != null) {
            sb.append("minVersion:");
            sb.append(this.minVersion + ",");
        }
        if (this.serverName != null) {
            sb.append("serverName:");
            sb.append(this.serverName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecureSkipVerify() {
        return this.withInsecureSkipVerify(true);
    }

    public class CertNested<N>
    extends SecretOrConfigMapFluent<CertNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        CertNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        public N and() {
            return (N)TLSConfigFluent.this.withCert(this.builder.build());
        }

        public N endCert() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends SecretOrConfigMapFluent<CaNested<N>>
    implements Nested<N> {
        SecretOrConfigMapBuilder builder;

        CaNested(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        public N and() {
            return (N)TLSConfigFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

