package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class APIServerConfigBuilder extends APIServerConfigFluent<APIServerConfigBuilder> implements VisitableBuilder<APIServerConfig,APIServerConfigBuilder>{
  public APIServerConfigBuilder() {
    this(new APIServerConfig());
  }
  
  public APIServerConfigBuilder(APIServerConfigFluent<?> fluent) {
    this(fluent, new APIServerConfig());
  }
  
  public APIServerConfigBuilder(APIServerConfigFluent<?> fluent,APIServerConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public APIServerConfigBuilder(APIServerConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  APIServerConfigFluent<?> fluent;
  
  public APIServerConfig build() {
    APIServerConfig buildable = new APIServerConfig(fluent.buildAuthorization(),fluent.buildBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getHost(),fluent.getNoProxy(),fluent.getProxyConnectHeader(),fluent.getProxyFromEnvironment(),fluent.getProxyUrl(),fluent.buildTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}