package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class APIServerConfigFluent<A extends APIServerConfigFluent<A>> extends BaseFluent<A>{
  public APIServerConfigFluent() {
  }
  
  public APIServerConfigFluent(APIServerConfig instance) {
    this.copyInstance(instance);
  }
  private AuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private String bearerToken;
  private String bearerTokenFile;
  private String host;
  private String noProxy;
  private Map<String,List<SecretKeySelector>> proxyConnectHeader;
  private Boolean proxyFromEnvironment;
  private String proxyUrl;
  private TLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(APIServerConfig instance) {
    instance = (instance != null ? instance : new APIServerConfig());
    if (instance != null) {
          this.withAuthorization(instance.getAuthorization());
          this.withBasicAuth(instance.getBasicAuth());
          this.withBearerToken(instance.getBearerToken());
          this.withBearerTokenFile(instance.getBearerTokenFile());
          this.withHost(instance.getHost());
          this.withNoProxy(instance.getNoProxy());
          this.withProxyConnectHeader(instance.getProxyConnectHeader());
          this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
          this.withProxyUrl(instance.getProxyUrl());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Authorization buildAuthorization() {
    return this.authorization != null ? this.authorization.build() : null;
  }
  
  public A withAuthorization(Authorization authorization) {
    this._visitables.remove("authorization");
    if (authorization != null) {
        this.authorization = new AuthorizationBuilder(authorization);
        this._visitables.get("authorization").add(this.authorization);
    } else {
        this.authorization = null;
        this._visitables.get("authorization").remove(this.authorization);
    }
    return (A) this;
  }
  
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  
  public AuthorizationNested<A> withNewAuthorization() {
    return new AuthorizationNested(null);
  }
  
  public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
    return new AuthorizationNested(item);
  }
  
  public AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(null));
  }
  
  public AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(new AuthorizationBuilder().build()));
  }
  
  public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
    return withNewAuthorizationLike(java.util.Optional.ofNullable(buildAuthorization()).orElse(item));
  }
  
  public BasicAuth buildBasicAuth() {
    return this.basicAuth != null ? this.basicAuth.build() : null;
  }
  
  public A withBasicAuth(BasicAuth basicAuth) {
    this._visitables.remove("basicAuth");
    if (basicAuth != null) {
        this.basicAuth = new BasicAuthBuilder(basicAuth);
        this._visitables.get("basicAuth").add(this.basicAuth);
    } else {
        this.basicAuth = null;
        this._visitables.get("basicAuth").remove(this.basicAuth);
    }
    return (A) this;
  }
  
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
    return new BasicAuthNested(item);
  }
  
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  
  public String getBearerToken() {
    return this.bearerToken;
  }
  
  public A withBearerToken(String bearerToken) {
    this.bearerToken = bearerToken;
    return (A) this;
  }
  
  public boolean hasBearerToken() {
    return this.bearerToken != null;
  }
  
  public String getBearerTokenFile() {
    return this.bearerTokenFile;
  }
  
  public A withBearerTokenFile(String bearerTokenFile) {
    this.bearerTokenFile = bearerTokenFile;
    return (A) this;
  }
  
  public boolean hasBearerTokenFile() {
    return this.bearerTokenFile != null;
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host = host;
    return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public String getNoProxy() {
    return this.noProxy;
  }
  
  public A withNoProxy(String noProxy) {
    this.noProxy = noProxy;
    return (A) this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null;
  }
  
  public A addToProxyConnectHeader(String key,List<SecretKeySelector> value) {
    if(this.proxyConnectHeader == null && key != null && value != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(key != null && value != null) {this.proxyConnectHeader.put(key, value);} return (A)this;
  }
  
  public A addToProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null && map != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(map != null) { this.proxyConnectHeader.putAll(map);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(String key) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(key != null && this.proxyConnectHeader != null) {this.proxyConnectHeader.remove(key);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.proxyConnectHeader != null){this.proxyConnectHeader.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<SecretKeySelector>> getProxyConnectHeader() {
    return this.proxyConnectHeader;
  }
  
  public <K,V>A withProxyConnectHeader(Map<String,List<SecretKeySelector>> proxyConnectHeader) {
    if (proxyConnectHeader == null) {
      this.proxyConnectHeader = null;
    } else {
      this.proxyConnectHeader = new LinkedHashMap(proxyConnectHeader);
    }
    return (A) this;
  }
  
  public boolean hasProxyConnectHeader() {
    return this.proxyConnectHeader != null;
  }
  
  public Boolean getProxyFromEnvironment() {
    return this.proxyFromEnvironment;
  }
  
  public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
    this.proxyFromEnvironment = proxyFromEnvironment;
    return (A) this;
  }
  
  public boolean hasProxyFromEnvironment() {
    return this.proxyFromEnvironment != null;
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public TLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(TLSConfig tlsConfig) {
    this._visitables.remove("tlsConfig");
    if (tlsConfig != null) {
        this.tlsConfig = new TLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerConfigFluent that = (APIServerConfigFluent) o;
    if (!java.util.Objects.equals(authorization, that.authorization)) return false;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;
    if (!java.util.Objects.equals(bearerToken, that.bearerToken)) return false;
    if (!java.util.Objects.equals(bearerTokenFile, that.bearerTokenFile)) return false;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(proxyConnectHeader, that.proxyConnectHeader)) return false;
    if (!java.util.Objects.equals(proxyFromEnvironment, that.proxyFromEnvironment)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerToken,  bearerTokenFile,  host,  noProxy,  proxyConnectHeader,  proxyFromEnvironment,  proxyUrl,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerToken != null) { sb.append("bearerToken:"); sb.append(bearerToken + ","); }
    if (bearerTokenFile != null) { sb.append("bearerTokenFile:"); sb.append(bearerTokenFile + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (proxyConnectHeader != null && !proxyConnectHeader.isEmpty()) { sb.append("proxyConnectHeader:"); sb.append(proxyConnectHeader + ","); }
    if (proxyFromEnvironment != null) { sb.append("proxyFromEnvironment:"); sb.append(proxyFromEnvironment + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withProxyFromEnvironment() {
    return withProxyFromEnvironment(true);
  }
  public class AuthorizationNested<N> extends AuthorizationFluent<AuthorizationNested<N>> implements Nested<N>{
    AuthorizationNested(Authorization item) {
      this.builder = new AuthorizationBuilder(this, item);
    }
    AuthorizationBuilder builder;
    
    public N and() {
      return (N) APIServerConfigFluent.this.withAuthorization(builder.build());
    }
    
    public N endAuthorization() {
      return and();
    }
    
  
  }
  public class BasicAuthNested<N> extends BasicAuthFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthBuilder builder;
    
    public N and() {
      return (N) APIServerConfigFluent.this.withBasicAuth(builder.build());
    }
    
    public N endBasicAuth() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends TLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) APIServerConfigFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}