package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertRelabelConfigSpecFluent<A extends AlertRelabelConfigSpecFluent<A>> extends BaseFluent<A>{
  public AlertRelabelConfigSpecFluent() {
  }
  
  public AlertRelabelConfigSpecFluent(AlertRelabelConfigSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<RelabelConfigBuilder> configs = new ArrayList<RelabelConfigBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertRelabelConfigSpec instance) {
    instance = (instance != null ? instance : new AlertRelabelConfigSpec());
    if (instance != null) {
          this.withConfigs(instance.getConfigs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConfigs(int index,RelabelConfig item) {
    if (this.configs == null) {this.configs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= configs.size()) {
        _visitables.get("configs").add(builder);
        configs.add(builder);
    } else {
        _visitables.get("configs").add(builder);
        configs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConfigs(int index,RelabelConfig item) {
    if (this.configs == null) {this.configs = new ArrayList<RelabelConfigBuilder>();}
    RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
    if (index < 0 || index >= configs.size()) {
        _visitables.get("configs").add(builder);
        configs.add(builder);
    } else {
        _visitables.get("configs").add(builder);
        configs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.configs == null) {this.configs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("configs").add(builder);this.configs.add(builder);} return (A)this;
  }
  
  public A addAllToConfigs(Collection<RelabelConfig> items) {
    if (this.configs == null) {this.configs = new ArrayList<RelabelConfigBuilder>();}
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("configs").add(builder);this.configs.add(builder);} return (A)this;
  }
  
  public A removeFromConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.configs == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("configs").remove(builder); this.configs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConfigs(Collection<RelabelConfig> items) {
    if (this.configs == null) return (A)this;
    for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("configs").remove(builder); this.configs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConfigs(Predicate<RelabelConfigBuilder> predicate) {
    if (configs == null) return (A) this;
    final Iterator<RelabelConfigBuilder> each = configs.iterator();
    final List visitables = _visitables.get("configs");
    while (each.hasNext()) {
      RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RelabelConfig> buildConfigs() {
    return this.configs != null ? build(configs) : null;
  }
  
  public RelabelConfig buildConfig(int index) {
    return this.configs.get(index).build();
  }
  
  public RelabelConfig buildFirstConfig() {
    return this.configs.get(0).build();
  }
  
  public RelabelConfig buildLastConfig() {
    return this.configs.get(configs.size() - 1).build();
  }
  
  public RelabelConfig buildMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : configs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
      for (RelabelConfigBuilder item : configs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConfigs(List<RelabelConfig> configs) {
    if (this.configs != null) {
      this._visitables.get("configs").clear();
    }
    if (configs != null) {
        this.configs = new ArrayList();
        for (RelabelConfig item : configs) {
          this.addToConfigs(item);
        }
    } else {
      this.configs = null;
    }
    return (A) this;
  }
  
  public A withConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... configs) {
    if (this.configs != null) {
        this.configs.clear();
        _visitables.remove("configs");
    }
    if (configs != null) {
      for (RelabelConfig item : configs) {
        this.addToConfigs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConfigs() {
    return this.configs != null && !this.configs.isEmpty();
  }
  
  public ConfigsNested<A> addNewConfig() {
    return new ConfigsNested(-1, null);
  }
  
  public ConfigsNested<A> addNewConfigLike(RelabelConfig item) {
    return new ConfigsNested(-1, item);
  }
  
  public ConfigsNested<A> setNewConfigLike(int index,RelabelConfig item) {
    return new ConfigsNested(index, item);
  }
  
  public ConfigsNested<A> editConfig(int index) {
    if (configs.size() <= index) throw new RuntimeException("Can't edit configs. Index exceeds size.");
    return setNewConfigLike(index, buildConfig(index));
  }
  
  public ConfigsNested<A> editFirstConfig() {
    if (configs.size() == 0) throw new RuntimeException("Can't edit first configs. The list is empty.");
    return setNewConfigLike(0, buildConfig(0));
  }
  
  public ConfigsNested<A> editLastConfig() {
    int index = configs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configs. The list is empty.");
    return setNewConfigLike(index, buildConfig(index));
  }
  
  public ConfigsNested<A> editMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configs.size();i++) { 
    if (predicate.test(configs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configs. No match found.");
    return setNewConfigLike(index, buildConfig(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertRelabelConfigSpecFluent that = (AlertRelabelConfigSpecFluent) o;
    if (!java.util.Objects.equals(configs, that.configs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(configs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configs != null && !configs.isEmpty()) { sb.append("configs:"); sb.append(configs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigsNested<N> extends RelabelConfigFluent<ConfigsNested<N>> implements Nested<N>{
    ConfigsNested(int index,RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertRelabelConfigSpecFluent.this.setToConfigs(index,builder.build());
    }
    
    public N endConfig() {
      return and();
    }
    
  
  }

}