package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertingSpecFluent<A extends AlertingSpecFluent<A>> extends BaseFluent<A>{
  public AlertingSpecFluent() {
  }
  
  public AlertingSpecFluent(AlertingSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<AlertmanagerEndpointsBuilder> alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertingSpec instance) {
    instance = (instance != null ? instance : new AlertingSpec());
    if (instance != null) {
          this.withAlertmanagers(instance.getAlertmanagers());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAlertmanagers(int index,AlertmanagerEndpoints item) {
    if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
    AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
    if (index < 0 || index >= alertmanagers.size()) {
        _visitables.get("alertmanagers").add(builder);
        alertmanagers.add(builder);
    } else {
        _visitables.get("alertmanagers").add(builder);
        alertmanagers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAlertmanagers(int index,AlertmanagerEndpoints item) {
    if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
    AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
    if (index < 0 || index >= alertmanagers.size()) {
        _visitables.get("alertmanagers").add(builder);
        alertmanagers.add(builder);
    } else {
        _visitables.get("alertmanagers").add(builder);
        alertmanagers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAlertmanagers(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpoints... items) {
    if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
    for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").add(builder);this.alertmanagers.add(builder);} return (A)this;
  }
  
  public A addAllToAlertmanagers(Collection<AlertmanagerEndpoints> items) {
    if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
    for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").add(builder);this.alertmanagers.add(builder);} return (A)this;
  }
  
  public A removeFromAlertmanagers(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpoints... items) {
    if (this.alertmanagers == null) return (A)this;
    for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").remove(builder); this.alertmanagers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAlertmanagers(Collection<AlertmanagerEndpoints> items) {
    if (this.alertmanagers == null) return (A)this;
    for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").remove(builder); this.alertmanagers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAlertmanagers(Predicate<AlertmanagerEndpointsBuilder> predicate) {
    if (alertmanagers == null) return (A) this;
    final Iterator<AlertmanagerEndpointsBuilder> each = alertmanagers.iterator();
    final List visitables = _visitables.get("alertmanagers");
    while (each.hasNext()) {
      AlertmanagerEndpointsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AlertmanagerEndpoints> buildAlertmanagers() {
    return this.alertmanagers != null ? build(alertmanagers) : null;
  }
  
  public AlertmanagerEndpoints buildAlertmanager(int index) {
    return this.alertmanagers.get(index).build();
  }
  
  public AlertmanagerEndpoints buildFirstAlertmanager() {
    return this.alertmanagers.get(0).build();
  }
  
  public AlertmanagerEndpoints buildLastAlertmanager() {
    return this.alertmanagers.get(alertmanagers.size() - 1).build();
  }
  
  public AlertmanagerEndpoints buildMatchingAlertmanager(Predicate<AlertmanagerEndpointsBuilder> predicate) {
      for (AlertmanagerEndpointsBuilder item : alertmanagers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAlertmanager(Predicate<AlertmanagerEndpointsBuilder> predicate) {
      for (AlertmanagerEndpointsBuilder item : alertmanagers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAlertmanagers(List<AlertmanagerEndpoints> alertmanagers) {
    if (this.alertmanagers != null) {
      this._visitables.get("alertmanagers").clear();
    }
    if (alertmanagers != null) {
        this.alertmanagers = new ArrayList();
        for (AlertmanagerEndpoints item : alertmanagers) {
          this.addToAlertmanagers(item);
        }
    } else {
      this.alertmanagers = null;
    }
    return (A) this;
  }
  
  public A withAlertmanagers(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpoints... alertmanagers) {
    if (this.alertmanagers != null) {
        this.alertmanagers.clear();
        _visitables.remove("alertmanagers");
    }
    if (alertmanagers != null) {
      for (AlertmanagerEndpoints item : alertmanagers) {
        this.addToAlertmanagers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAlertmanagers() {
    return this.alertmanagers != null && !this.alertmanagers.isEmpty();
  }
  
  public AlertmanagersNested<A> addNewAlertmanager() {
    return new AlertmanagersNested(-1, null);
  }
  
  public AlertmanagersNested<A> addNewAlertmanagerLike(AlertmanagerEndpoints item) {
    return new AlertmanagersNested(-1, item);
  }
  
  public AlertmanagersNested<A> setNewAlertmanagerLike(int index,AlertmanagerEndpoints item) {
    return new AlertmanagersNested(index, item);
  }
  
  public AlertmanagersNested<A> editAlertmanager(int index) {
    if (alertmanagers.size() <= index) throw new RuntimeException("Can't edit alertmanagers. Index exceeds size.");
    return setNewAlertmanagerLike(index, buildAlertmanager(index));
  }
  
  public AlertmanagersNested<A> editFirstAlertmanager() {
    if (alertmanagers.size() == 0) throw new RuntimeException("Can't edit first alertmanagers. The list is empty.");
    return setNewAlertmanagerLike(0, buildAlertmanager(0));
  }
  
  public AlertmanagersNested<A> editLastAlertmanager() {
    int index = alertmanagers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last alertmanagers. The list is empty.");
    return setNewAlertmanagerLike(index, buildAlertmanager(index));
  }
  
  public AlertmanagersNested<A> editMatchingAlertmanager(Predicate<AlertmanagerEndpointsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<alertmanagers.size();i++) { 
    if (predicate.test(alertmanagers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching alertmanagers. No match found.");
    return setNewAlertmanagerLike(index, buildAlertmanager(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertingSpecFluent that = (AlertingSpecFluent) o;
    if (!java.util.Objects.equals(alertmanagers, that.alertmanagers)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(alertmanagers,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alertmanagers != null && !alertmanagers.isEmpty()) { sb.append("alertmanagers:"); sb.append(alertmanagers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AlertmanagersNested<N> extends AlertmanagerEndpointsFluent<AlertmanagersNested<N>> implements Nested<N>{
    AlertmanagersNested(int index,AlertmanagerEndpoints item) {
      this.index = index;
      this.builder = new AlertmanagerEndpointsBuilder(this, item);
    }
    AlertmanagerEndpointsBuilder builder;
    int index;
    
    public N and() {
      return (N) AlertingSpecFluent.this.setToAlertmanagers(index,builder.build());
    }
    
    public N endAlertmanager() {
      return and();
    }
    
  
  }

}