package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertmanagerGlobalConfigFluent<A extends AlertmanagerGlobalConfigFluent<A>> extends BaseFluent<A>{
  public AlertmanagerGlobalConfigFluent() {
  }
  
  public AlertmanagerGlobalConfigFluent(AlertmanagerGlobalConfig instance) {
    this.copyInstance(instance);
  }
  private HTTPConfigBuilder httpConfig;
  private GlobalJiraConfigBuilder jira;
  private SecretKeySelector opsGenieApiKey;
  private SecretKeySelector opsGenieApiUrl;
  private String pagerdutyUrl;
  private String resolveTimeout;
  private GlobalRocketChatConfigBuilder rocketChat;
  private SecretKeySelector slackApiUrl;
  private GlobalSMTPConfigBuilder smtp;
  private GlobalTelegramConfigBuilder telegram;
  private GlobalVictorOpsConfigBuilder victorops;
  private GlobalWebexConfigBuilder webex;
  private GlobalWeChatConfigBuilder wechat;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertmanagerGlobalConfig instance) {
    instance = (instance != null ? instance : new AlertmanagerGlobalConfig());
    if (instance != null) {
          this.withHttpConfig(instance.getHttpConfig());
          this.withJira(instance.getJira());
          this.withOpsGenieApiKey(instance.getOpsGenieApiKey());
          this.withOpsGenieApiUrl(instance.getOpsGenieApiUrl());
          this.withPagerdutyUrl(instance.getPagerdutyUrl());
          this.withResolveTimeout(instance.getResolveTimeout());
          this.withRocketChat(instance.getRocketChat());
          this.withSlackApiUrl(instance.getSlackApiUrl());
          this.withSmtp(instance.getSmtp());
          this.withTelegram(instance.getTelegram());
          this.withVictorops(instance.getVictorops());
          this.withWebex(instance.getWebex());
          this.withWechat(instance.getWechat());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public GlobalJiraConfig buildJira() {
    return this.jira != null ? this.jira.build() : null;
  }
  
  public A withJira(GlobalJiraConfig jira) {
    this._visitables.remove("jira");
    if (jira != null) {
        this.jira = new GlobalJiraConfigBuilder(jira);
        this._visitables.get("jira").add(this.jira);
    } else {
        this.jira = null;
        this._visitables.get("jira").remove(this.jira);
    }
    return (A) this;
  }
  
  public boolean hasJira() {
    return this.jira != null;
  }
  
  public A withNewJira(String apiURL) {
    return (A)withJira(new GlobalJiraConfig(apiURL));
  }
  
  public JiraNested<A> withNewJira() {
    return new JiraNested(null);
  }
  
  public JiraNested<A> withNewJiraLike(GlobalJiraConfig item) {
    return new JiraNested(item);
  }
  
  public JiraNested<A> editJira() {
    return withNewJiraLike(java.util.Optional.ofNullable(buildJira()).orElse(null));
  }
  
  public JiraNested<A> editOrNewJira() {
    return withNewJiraLike(java.util.Optional.ofNullable(buildJira()).orElse(new GlobalJiraConfigBuilder().build()));
  }
  
  public JiraNested<A> editOrNewJiraLike(GlobalJiraConfig item) {
    return withNewJiraLike(java.util.Optional.ofNullable(buildJira()).orElse(item));
  }
  
  public SecretKeySelector getOpsGenieApiKey() {
    return this.opsGenieApiKey;
  }
  
  public A withOpsGenieApiKey(SecretKeySelector opsGenieApiKey) {
    this.opsGenieApiKey = opsGenieApiKey;
    return (A) this;
  }
  
  public boolean hasOpsGenieApiKey() {
    return this.opsGenieApiKey != null;
  }
  
  public A withNewOpsGenieApiKey(String key,String name,Boolean optional) {
    return (A)withOpsGenieApiKey(new SecretKeySelector(key, name, optional));
  }
  
  public SecretKeySelector getOpsGenieApiUrl() {
    return this.opsGenieApiUrl;
  }
  
  public A withOpsGenieApiUrl(SecretKeySelector opsGenieApiUrl) {
    this.opsGenieApiUrl = opsGenieApiUrl;
    return (A) this;
  }
  
  public boolean hasOpsGenieApiUrl() {
    return this.opsGenieApiUrl != null;
  }
  
  public A withNewOpsGenieApiUrl(String key,String name,Boolean optional) {
    return (A)withOpsGenieApiUrl(new SecretKeySelector(key, name, optional));
  }
  
  public String getPagerdutyUrl() {
    return this.pagerdutyUrl;
  }
  
  public A withPagerdutyUrl(String pagerdutyUrl) {
    this.pagerdutyUrl = pagerdutyUrl;
    return (A) this;
  }
  
  public boolean hasPagerdutyUrl() {
    return this.pagerdutyUrl != null;
  }
  
  public String getResolveTimeout() {
    return this.resolveTimeout;
  }
  
  public A withResolveTimeout(String resolveTimeout) {
    this.resolveTimeout = resolveTimeout;
    return (A) this;
  }
  
  public boolean hasResolveTimeout() {
    return this.resolveTimeout != null;
  }
  
  public GlobalRocketChatConfig buildRocketChat() {
    return this.rocketChat != null ? this.rocketChat.build() : null;
  }
  
  public A withRocketChat(GlobalRocketChatConfig rocketChat) {
    this._visitables.remove("rocketChat");
    if (rocketChat != null) {
        this.rocketChat = new GlobalRocketChatConfigBuilder(rocketChat);
        this._visitables.get("rocketChat").add(this.rocketChat);
    } else {
        this.rocketChat = null;
        this._visitables.get("rocketChat").remove(this.rocketChat);
    }
    return (A) this;
  }
  
  public boolean hasRocketChat() {
    return this.rocketChat != null;
  }
  
  public RocketChatNested<A> withNewRocketChat() {
    return new RocketChatNested(null);
  }
  
  public RocketChatNested<A> withNewRocketChatLike(GlobalRocketChatConfig item) {
    return new RocketChatNested(item);
  }
  
  public RocketChatNested<A> editRocketChat() {
    return withNewRocketChatLike(java.util.Optional.ofNullable(buildRocketChat()).orElse(null));
  }
  
  public RocketChatNested<A> editOrNewRocketChat() {
    return withNewRocketChatLike(java.util.Optional.ofNullable(buildRocketChat()).orElse(new GlobalRocketChatConfigBuilder().build()));
  }
  
  public RocketChatNested<A> editOrNewRocketChatLike(GlobalRocketChatConfig item) {
    return withNewRocketChatLike(java.util.Optional.ofNullable(buildRocketChat()).orElse(item));
  }
  
  public SecretKeySelector getSlackApiUrl() {
    return this.slackApiUrl;
  }
  
  public A withSlackApiUrl(SecretKeySelector slackApiUrl) {
    this.slackApiUrl = slackApiUrl;
    return (A) this;
  }
  
  public boolean hasSlackApiUrl() {
    return this.slackApiUrl != null;
  }
  
  public A withNewSlackApiUrl(String key,String name,Boolean optional) {
    return (A)withSlackApiUrl(new SecretKeySelector(key, name, optional));
  }
  
  public GlobalSMTPConfig buildSmtp() {
    return this.smtp != null ? this.smtp.build() : null;
  }
  
  public A withSmtp(GlobalSMTPConfig smtp) {
    this._visitables.remove("smtp");
    if (smtp != null) {
        this.smtp = new GlobalSMTPConfigBuilder(smtp);
        this._visitables.get("smtp").add(this.smtp);
    } else {
        this.smtp = null;
        this._visitables.get("smtp").remove(this.smtp);
    }
    return (A) this;
  }
  
  public boolean hasSmtp() {
    return this.smtp != null;
  }
  
  public SmtpNested<A> withNewSmtp() {
    return new SmtpNested(null);
  }
  
  public SmtpNested<A> withNewSmtpLike(GlobalSMTPConfig item) {
    return new SmtpNested(item);
  }
  
  public SmtpNested<A> editSmtp() {
    return withNewSmtpLike(java.util.Optional.ofNullable(buildSmtp()).orElse(null));
  }
  
  public SmtpNested<A> editOrNewSmtp() {
    return withNewSmtpLike(java.util.Optional.ofNullable(buildSmtp()).orElse(new GlobalSMTPConfigBuilder().build()));
  }
  
  public SmtpNested<A> editOrNewSmtpLike(GlobalSMTPConfig item) {
    return withNewSmtpLike(java.util.Optional.ofNullable(buildSmtp()).orElse(item));
  }
  
  public GlobalTelegramConfig buildTelegram() {
    return this.telegram != null ? this.telegram.build() : null;
  }
  
  public A withTelegram(GlobalTelegramConfig telegram) {
    this._visitables.remove("telegram");
    if (telegram != null) {
        this.telegram = new GlobalTelegramConfigBuilder(telegram);
        this._visitables.get("telegram").add(this.telegram);
    } else {
        this.telegram = null;
        this._visitables.get("telegram").remove(this.telegram);
    }
    return (A) this;
  }
  
  public boolean hasTelegram() {
    return this.telegram != null;
  }
  
  public A withNewTelegram(String apiURL) {
    return (A)withTelegram(new GlobalTelegramConfig(apiURL));
  }
  
  public TelegramNested<A> withNewTelegram() {
    return new TelegramNested(null);
  }
  
  public TelegramNested<A> withNewTelegramLike(GlobalTelegramConfig item) {
    return new TelegramNested(item);
  }
  
  public TelegramNested<A> editTelegram() {
    return withNewTelegramLike(java.util.Optional.ofNullable(buildTelegram()).orElse(null));
  }
  
  public TelegramNested<A> editOrNewTelegram() {
    return withNewTelegramLike(java.util.Optional.ofNullable(buildTelegram()).orElse(new GlobalTelegramConfigBuilder().build()));
  }
  
  public TelegramNested<A> editOrNewTelegramLike(GlobalTelegramConfig item) {
    return withNewTelegramLike(java.util.Optional.ofNullable(buildTelegram()).orElse(item));
  }
  
  public GlobalVictorOpsConfig buildVictorops() {
    return this.victorops != null ? this.victorops.build() : null;
  }
  
  public A withVictorops(GlobalVictorOpsConfig victorops) {
    this._visitables.remove("victorops");
    if (victorops != null) {
        this.victorops = new GlobalVictorOpsConfigBuilder(victorops);
        this._visitables.get("victorops").add(this.victorops);
    } else {
        this.victorops = null;
        this._visitables.get("victorops").remove(this.victorops);
    }
    return (A) this;
  }
  
  public boolean hasVictorops() {
    return this.victorops != null;
  }
  
  public VictoropsNested<A> withNewVictorops() {
    return new VictoropsNested(null);
  }
  
  public VictoropsNested<A> withNewVictoropsLike(GlobalVictorOpsConfig item) {
    return new VictoropsNested(item);
  }
  
  public VictoropsNested<A> editVictorops() {
    return withNewVictoropsLike(java.util.Optional.ofNullable(buildVictorops()).orElse(null));
  }
  
  public VictoropsNested<A> editOrNewVictorops() {
    return withNewVictoropsLike(java.util.Optional.ofNullable(buildVictorops()).orElse(new GlobalVictorOpsConfigBuilder().build()));
  }
  
  public VictoropsNested<A> editOrNewVictoropsLike(GlobalVictorOpsConfig item) {
    return withNewVictoropsLike(java.util.Optional.ofNullable(buildVictorops()).orElse(item));
  }
  
  public GlobalWebexConfig buildWebex() {
    return this.webex != null ? this.webex.build() : null;
  }
  
  public A withWebex(GlobalWebexConfig webex) {
    this._visitables.remove("webex");
    if (webex != null) {
        this.webex = new GlobalWebexConfigBuilder(webex);
        this._visitables.get("webex").add(this.webex);
    } else {
        this.webex = null;
        this._visitables.get("webex").remove(this.webex);
    }
    return (A) this;
  }
  
  public boolean hasWebex() {
    return this.webex != null;
  }
  
  public A withNewWebex(String apiURL) {
    return (A)withWebex(new GlobalWebexConfig(apiURL));
  }
  
  public WebexNested<A> withNewWebex() {
    return new WebexNested(null);
  }
  
  public WebexNested<A> withNewWebexLike(GlobalWebexConfig item) {
    return new WebexNested(item);
  }
  
  public WebexNested<A> editWebex() {
    return withNewWebexLike(java.util.Optional.ofNullable(buildWebex()).orElse(null));
  }
  
  public WebexNested<A> editOrNewWebex() {
    return withNewWebexLike(java.util.Optional.ofNullable(buildWebex()).orElse(new GlobalWebexConfigBuilder().build()));
  }
  
  public WebexNested<A> editOrNewWebexLike(GlobalWebexConfig item) {
    return withNewWebexLike(java.util.Optional.ofNullable(buildWebex()).orElse(item));
  }
  
  public GlobalWeChatConfig buildWechat() {
    return this.wechat != null ? this.wechat.build() : null;
  }
  
  public A withWechat(GlobalWeChatConfig wechat) {
    this._visitables.remove("wechat");
    if (wechat != null) {
        this.wechat = new GlobalWeChatConfigBuilder(wechat);
        this._visitables.get("wechat").add(this.wechat);
    } else {
        this.wechat = null;
        this._visitables.get("wechat").remove(this.wechat);
    }
    return (A) this;
  }
  
  public boolean hasWechat() {
    return this.wechat != null;
  }
  
  public WechatNested<A> withNewWechat() {
    return new WechatNested(null);
  }
  
  public WechatNested<A> withNewWechatLike(GlobalWeChatConfig item) {
    return new WechatNested(item);
  }
  
  public WechatNested<A> editWechat() {
    return withNewWechatLike(java.util.Optional.ofNullable(buildWechat()).orElse(null));
  }
  
  public WechatNested<A> editOrNewWechat() {
    return withNewWechatLike(java.util.Optional.ofNullable(buildWechat()).orElse(new GlobalWeChatConfigBuilder().build()));
  }
  
  public WechatNested<A> editOrNewWechatLike(GlobalWeChatConfig item) {
    return withNewWechatLike(java.util.Optional.ofNullable(buildWechat()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertmanagerGlobalConfigFluent that = (AlertmanagerGlobalConfigFluent) o;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(jira, that.jira)) return false;
    if (!java.util.Objects.equals(opsGenieApiKey, that.opsGenieApiKey)) return false;
    if (!java.util.Objects.equals(opsGenieApiUrl, that.opsGenieApiUrl)) return false;
    if (!java.util.Objects.equals(pagerdutyUrl, that.pagerdutyUrl)) return false;
    if (!java.util.Objects.equals(resolveTimeout, that.resolveTimeout)) return false;
    if (!java.util.Objects.equals(rocketChat, that.rocketChat)) return false;
    if (!java.util.Objects.equals(slackApiUrl, that.slackApiUrl)) return false;
    if (!java.util.Objects.equals(smtp, that.smtp)) return false;
    if (!java.util.Objects.equals(telegram, that.telegram)) return false;
    if (!java.util.Objects.equals(victorops, that.victorops)) return false;
    if (!java.util.Objects.equals(webex, that.webex)) return false;
    if (!java.util.Objects.equals(wechat, that.wechat)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpConfig,  jira,  opsGenieApiKey,  opsGenieApiUrl,  pagerdutyUrl,  resolveTimeout,  rocketChat,  slackApiUrl,  smtp,  telegram,  victorops,  webex,  wechat,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (jira != null) { sb.append("jira:"); sb.append(jira + ","); }
    if (opsGenieApiKey != null) { sb.append("opsGenieApiKey:"); sb.append(opsGenieApiKey + ","); }
    if (opsGenieApiUrl != null) { sb.append("opsGenieApiUrl:"); sb.append(opsGenieApiUrl + ","); }
    if (pagerdutyUrl != null) { sb.append("pagerdutyUrl:"); sb.append(pagerdutyUrl + ","); }
    if (resolveTimeout != null) { sb.append("resolveTimeout:"); sb.append(resolveTimeout + ","); }
    if (rocketChat != null) { sb.append("rocketChat:"); sb.append(rocketChat + ","); }
    if (slackApiUrl != null) { sb.append("slackApiUrl:"); sb.append(slackApiUrl + ","); }
    if (smtp != null) { sb.append("smtp:"); sb.append(smtp + ","); }
    if (telegram != null) { sb.append("telegram:"); sb.append(telegram + ","); }
    if (victorops != null) { sb.append("victorops:"); sb.append(victorops + ","); }
    if (webex != null) { sb.append("webex:"); sb.append(webex + ","); }
    if (wechat != null) { sb.append("wechat:"); sb.append(wechat + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }
  public class JiraNested<N> extends GlobalJiraConfigFluent<JiraNested<N>> implements Nested<N>{
    JiraNested(GlobalJiraConfig item) {
      this.builder = new GlobalJiraConfigBuilder(this, item);
    }
    GlobalJiraConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withJira(builder.build());
    }
    
    public N endJira() {
      return and();
    }
    
  
  }
  public class RocketChatNested<N> extends GlobalRocketChatConfigFluent<RocketChatNested<N>> implements Nested<N>{
    RocketChatNested(GlobalRocketChatConfig item) {
      this.builder = new GlobalRocketChatConfigBuilder(this, item);
    }
    GlobalRocketChatConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withRocketChat(builder.build());
    }
    
    public N endRocketChat() {
      return and();
    }
    
  
  }
  public class SmtpNested<N> extends GlobalSMTPConfigFluent<SmtpNested<N>> implements Nested<N>{
    SmtpNested(GlobalSMTPConfig item) {
      this.builder = new GlobalSMTPConfigBuilder(this, item);
    }
    GlobalSMTPConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withSmtp(builder.build());
    }
    
    public N endSmtp() {
      return and();
    }
    
  
  }
  public class TelegramNested<N> extends GlobalTelegramConfigFluent<TelegramNested<N>> implements Nested<N>{
    TelegramNested(GlobalTelegramConfig item) {
      this.builder = new GlobalTelegramConfigBuilder(this, item);
    }
    GlobalTelegramConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withTelegram(builder.build());
    }
    
    public N endTelegram() {
      return and();
    }
    
  
  }
  public class VictoropsNested<N> extends GlobalVictorOpsConfigFluent<VictoropsNested<N>> implements Nested<N>{
    VictoropsNested(GlobalVictorOpsConfig item) {
      this.builder = new GlobalVictorOpsConfigBuilder(this, item);
    }
    GlobalVictorOpsConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withVictorops(builder.build());
    }
    
    public N endVictorops() {
      return and();
    }
    
  
  }
  public class WebexNested<N> extends GlobalWebexConfigFluent<WebexNested<N>> implements Nested<N>{
    WebexNested(GlobalWebexConfig item) {
      this.builder = new GlobalWebexConfigBuilder(this, item);
    }
    GlobalWebexConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withWebex(builder.build());
    }
    
    public N endWebex() {
      return and();
    }
    
  
  }
  public class WechatNested<N> extends GlobalWeChatConfigFluent<WechatNested<N>> implements Nested<N>{
    WechatNested(GlobalWeChatConfig item) {
      this.builder = new GlobalWeChatConfigBuilder(this, item);
    }
    GlobalWeChatConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withWechat(builder.build());
    }
    
    public N endWechat() {
      return and();
    }
    
  
  }

}