package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterTLSConfigBuilder extends ClusterTLSConfigFluent<ClusterTLSConfigBuilder> implements VisitableBuilder<ClusterTLSConfig,ClusterTLSConfigBuilder>{
  public ClusterTLSConfigBuilder() {
    this(new ClusterTLSConfig());
  }
  
  public ClusterTLSConfigBuilder(ClusterTLSConfigFluent<?> fluent) {
    this(fluent, new ClusterTLSConfig());
  }
  
  public ClusterTLSConfigBuilder(ClusterTLSConfigFluent<?> fluent,ClusterTLSConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterTLSConfigBuilder(ClusterTLSConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterTLSConfigFluent<?> fluent;
  
  public ClusterTLSConfig build() {
    ClusterTLSConfig buildable = new ClusterTLSConfig(fluent.buildClient(),fluent.buildServer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}