package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterTLSConfigFluent<A extends ClusterTLSConfigFluent<A>> extends BaseFluent<A>{
  public ClusterTLSConfigFluent() {
  }
  
  public ClusterTLSConfigFluent(ClusterTLSConfig instance) {
    this.copyInstance(instance);
  }
  private SafeTLSConfigBuilder client;
  private WebTLSConfigBuilder server;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterTLSConfig instance) {
    instance = (instance != null ? instance : new ClusterTLSConfig());
    if (instance != null) {
          this.withClient(instance.getClient());
          this.withServer(instance.getServer());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SafeTLSConfig buildClient() {
    return this.client != null ? this.client.build() : null;
  }
  
  public A withClient(SafeTLSConfig client) {
    this._visitables.remove("client");
    if (client != null) {
        this.client = new SafeTLSConfigBuilder(client);
        this._visitables.get("client").add(this.client);
    } else {
        this.client = null;
        this._visitables.get("client").remove(this.client);
    }
    return (A) this;
  }
  
  public boolean hasClient() {
    return this.client != null;
  }
  
  public ClientNested<A> withNewClient() {
    return new ClientNested(null);
  }
  
  public ClientNested<A> withNewClientLike(SafeTLSConfig item) {
    return new ClientNested(item);
  }
  
  public ClientNested<A> editClient() {
    return withNewClientLike(java.util.Optional.ofNullable(buildClient()).orElse(null));
  }
  
  public ClientNested<A> editOrNewClient() {
    return withNewClientLike(java.util.Optional.ofNullable(buildClient()).orElse(new SafeTLSConfigBuilder().build()));
  }
  
  public ClientNested<A> editOrNewClientLike(SafeTLSConfig item) {
    return withNewClientLike(java.util.Optional.ofNullable(buildClient()).orElse(item));
  }
  
  public WebTLSConfig buildServer() {
    return this.server != null ? this.server.build() : null;
  }
  
  public A withServer(WebTLSConfig server) {
    this._visitables.remove("server");
    if (server != null) {
        this.server = new WebTLSConfigBuilder(server);
        this._visitables.get("server").add(this.server);
    } else {
        this.server = null;
        this._visitables.get("server").remove(this.server);
    }
    return (A) this;
  }
  
  public boolean hasServer() {
    return this.server != null;
  }
  
  public ServerNested<A> withNewServer() {
    return new ServerNested(null);
  }
  
  public ServerNested<A> withNewServerLike(WebTLSConfig item) {
    return new ServerNested(item);
  }
  
  public ServerNested<A> editServer() {
    return withNewServerLike(java.util.Optional.ofNullable(buildServer()).orElse(null));
  }
  
  public ServerNested<A> editOrNewServer() {
    return withNewServerLike(java.util.Optional.ofNullable(buildServer()).orElse(new WebTLSConfigBuilder().build()));
  }
  
  public ServerNested<A> editOrNewServerLike(WebTLSConfig item) {
    return withNewServerLike(java.util.Optional.ofNullable(buildServer()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterTLSConfigFluent that = (ClusterTLSConfigFluent) o;
    if (!java.util.Objects.equals(client, that.client)) return false;
    if (!java.util.Objects.equals(server, that.server)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(client,  server,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (client != null) { sb.append("client:"); sb.append(client + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClientNested<N> extends SafeTLSConfigFluent<ClientNested<N>> implements Nested<N>{
    ClientNested(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    SafeTLSConfigBuilder builder;
    
    public N and() {
      return (N) ClusterTLSConfigFluent.this.withClient(builder.build());
    }
    
    public N endClient() {
      return and();
    }
    
  
  }
  public class ServerNested<N> extends WebTLSConfigFluent<ServerNested<N>> implements Nested<N>{
    ServerNested(WebTLSConfig item) {
      this.builder = new WebTLSConfigBuilder(this, item);
    }
    WebTLSConfigBuilder builder;
    
    public N and() {
      return (N) ClusterTLSConfigFluent.this.withServer(builder.build());
    }
    
    public N endServer() {
      return and();
    }
    
  
  }

}