package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GlobalSMTPConfigFluent<A extends GlobalSMTPConfigFluent<A>> extends BaseFluent<A>{
  public GlobalSMTPConfigFluent() {
  }
  
  public GlobalSMTPConfigFluent(GlobalSMTPConfig instance) {
    this.copyInstance(instance);
  }
  private String authIdentity;
  private SecretKeySelector authPassword;
  private SecretKeySelector authSecret;
  private String authUsername;
  private String from;
  private String hello;
  private Boolean requireTLS;
  private HostPortBuilder smartHost;
  private SafeTLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GlobalSMTPConfig instance) {
    instance = (instance != null ? instance : new GlobalSMTPConfig());
    if (instance != null) {
          this.withAuthIdentity(instance.getAuthIdentity());
          this.withAuthPassword(instance.getAuthPassword());
          this.withAuthSecret(instance.getAuthSecret());
          this.withAuthUsername(instance.getAuthUsername());
          this.withFrom(instance.getFrom());
          this.withHello(instance.getHello());
          this.withRequireTLS(instance.getRequireTLS());
          this.withSmartHost(instance.getSmartHost());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAuthIdentity() {
    return this.authIdentity;
  }
  
  public A withAuthIdentity(String authIdentity) {
    this.authIdentity = authIdentity;
    return (A) this;
  }
  
  public boolean hasAuthIdentity() {
    return this.authIdentity != null;
  }
  
  public SecretKeySelector getAuthPassword() {
    return this.authPassword;
  }
  
  public A withAuthPassword(SecretKeySelector authPassword) {
    this.authPassword = authPassword;
    return (A) this;
  }
  
  public boolean hasAuthPassword() {
    return this.authPassword != null;
  }
  
  public A withNewAuthPassword(String key,String name,Boolean optional) {
    return (A)withAuthPassword(new SecretKeySelector(key, name, optional));
  }
  
  public SecretKeySelector getAuthSecret() {
    return this.authSecret;
  }
  
  public A withAuthSecret(SecretKeySelector authSecret) {
    this.authSecret = authSecret;
    return (A) this;
  }
  
  public boolean hasAuthSecret() {
    return this.authSecret != null;
  }
  
  public A withNewAuthSecret(String key,String name,Boolean optional) {
    return (A)withAuthSecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getAuthUsername() {
    return this.authUsername;
  }
  
  public A withAuthUsername(String authUsername) {
    this.authUsername = authUsername;
    return (A) this;
  }
  
  public boolean hasAuthUsername() {
    return this.authUsername != null;
  }
  
  public String getFrom() {
    return this.from;
  }
  
  public A withFrom(String from) {
    this.from = from;
    return (A) this;
  }
  
  public boolean hasFrom() {
    return this.from != null;
  }
  
  public String getHello() {
    return this.hello;
  }
  
  public A withHello(String hello) {
    this.hello = hello;
    return (A) this;
  }
  
  public boolean hasHello() {
    return this.hello != null;
  }
  
  public Boolean getRequireTLS() {
    return this.requireTLS;
  }
  
  public A withRequireTLS(Boolean requireTLS) {
    this.requireTLS = requireTLS;
    return (A) this;
  }
  
  public boolean hasRequireTLS() {
    return this.requireTLS != null;
  }
  
  public HostPort buildSmartHost() {
    return this.smartHost != null ? this.smartHost.build() : null;
  }
  
  public A withSmartHost(HostPort smartHost) {
    this._visitables.remove("smartHost");
    if (smartHost != null) {
        this.smartHost = new HostPortBuilder(smartHost);
        this._visitables.get("smartHost").add(this.smartHost);
    } else {
        this.smartHost = null;
        this._visitables.get("smartHost").remove(this.smartHost);
    }
    return (A) this;
  }
  
  public boolean hasSmartHost() {
    return this.smartHost != null;
  }
  
  public A withNewSmartHost(String host,String port) {
    return (A)withSmartHost(new HostPort(host, port));
  }
  
  public SmartHostNested<A> withNewSmartHost() {
    return new SmartHostNested(null);
  }
  
  public SmartHostNested<A> withNewSmartHostLike(HostPort item) {
    return new SmartHostNested(item);
  }
  
  public SmartHostNested<A> editSmartHost() {
    return withNewSmartHostLike(java.util.Optional.ofNullable(buildSmartHost()).orElse(null));
  }
  
  public SmartHostNested<A> editOrNewSmartHost() {
    return withNewSmartHostLike(java.util.Optional.ofNullable(buildSmartHost()).orElse(new HostPortBuilder().build()));
  }
  
  public SmartHostNested<A> editOrNewSmartHostLike(HostPort item) {
    return withNewSmartHostLike(java.util.Optional.ofNullable(buildSmartHost()).orElse(item));
  }
  
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    this._visitables.remove("tlsConfig");
    if (tlsConfig != null) {
        this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GlobalSMTPConfigFluent that = (GlobalSMTPConfigFluent) o;
    if (!java.util.Objects.equals(authIdentity, that.authIdentity)) return false;
    if (!java.util.Objects.equals(authPassword, that.authPassword)) return false;
    if (!java.util.Objects.equals(authSecret, that.authSecret)) return false;
    if (!java.util.Objects.equals(authUsername, that.authUsername)) return false;
    if (!java.util.Objects.equals(from, that.from)) return false;
    if (!java.util.Objects.equals(hello, that.hello)) return false;
    if (!java.util.Objects.equals(requireTLS, that.requireTLS)) return false;
    if (!java.util.Objects.equals(smartHost, that.smartHost)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authIdentity,  authPassword,  authSecret,  authUsername,  from,  hello,  requireTLS,  smartHost,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authIdentity != null) { sb.append("authIdentity:"); sb.append(authIdentity + ","); }
    if (authPassword != null) { sb.append("authPassword:"); sb.append(authPassword + ","); }
    if (authSecret != null) { sb.append("authSecret:"); sb.append(authSecret + ","); }
    if (authUsername != null) { sb.append("authUsername:"); sb.append(authUsername + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (hello != null) { sb.append("hello:"); sb.append(hello + ","); }
    if (requireTLS != null) { sb.append("requireTLS:"); sb.append(requireTLS + ","); }
    if (smartHost != null) { sb.append("smartHost:"); sb.append(smartHost + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withRequireTLS() {
    return withRequireTLS(true);
  }
  public class SmartHostNested<N> extends HostPortFluent<SmartHostNested<N>> implements Nested<N>{
    SmartHostNested(HostPort item) {
      this.builder = new HostPortBuilder(this, item);
    }
    HostPortBuilder builder;
    
    public N and() {
      return (N) GlobalSMTPConfigFluent.this.withSmartHost(builder.build());
    }
    
    public N endSmartHost() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends SafeTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    SafeTLSConfigBuilder builder;
    
    public N and() {
      return (N) GlobalSMTPConfigFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}