package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GlobalWeChatConfigFluent<A extends GlobalWeChatConfigFluent<A>> extends BaseFluent<A>{
  public GlobalWeChatConfigFluent() {
  }
  
  public GlobalWeChatConfigFluent(GlobalWeChatConfig instance) {
    this.copyInstance(instance);
  }
  private String apiCorpID;
  private SecretKeySelector apiSecret;
  private String apiURL;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GlobalWeChatConfig instance) {
    instance = (instance != null ? instance : new GlobalWeChatConfig());
    if (instance != null) {
          this.withApiCorpID(instance.getApiCorpID());
          this.withApiSecret(instance.getApiSecret());
          this.withApiURL(instance.getApiURL());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiCorpID() {
    return this.apiCorpID;
  }
  
  public A withApiCorpID(String apiCorpID) {
    this.apiCorpID = apiCorpID;
    return (A) this;
  }
  
  public boolean hasApiCorpID() {
    return this.apiCorpID != null;
  }
  
  public SecretKeySelector getApiSecret() {
    return this.apiSecret;
  }
  
  public A withApiSecret(SecretKeySelector apiSecret) {
    this.apiSecret = apiSecret;
    return (A) this;
  }
  
  public boolean hasApiSecret() {
    return this.apiSecret != null;
  }
  
  public A withNewApiSecret(String key,String name,Boolean optional) {
    return (A)withApiSecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getApiURL() {
    return this.apiURL;
  }
  
  public A withApiURL(String apiURL) {
    this.apiURL = apiURL;
    return (A) this;
  }
  
  public boolean hasApiURL() {
    return this.apiURL != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GlobalWeChatConfigFluent that = (GlobalWeChatConfigFluent) o;
    if (!java.util.Objects.equals(apiCorpID, that.apiCorpID)) return false;
    if (!java.util.Objects.equals(apiSecret, that.apiSecret)) return false;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiCorpID,  apiSecret,  apiURL,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiCorpID != null) { sb.append("apiCorpID:"); sb.append(apiCorpID + ","); }
    if (apiSecret != null) { sb.append("apiSecret:"); sb.append(apiSecret + ","); }
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}