package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MetadataConfigBuilder extends MetadataConfigFluent<MetadataConfigBuilder> implements VisitableBuilder<MetadataConfig,MetadataConfigBuilder>{
  public MetadataConfigBuilder() {
    this(new MetadataConfig());
  }
  
  public MetadataConfigBuilder(MetadataConfigFluent<?> fluent) {
    this(fluent, new MetadataConfig());
  }
  
  public MetadataConfigBuilder(MetadataConfigFluent<?> fluent,MetadataConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MetadataConfigBuilder(MetadataConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MetadataConfigFluent<?> fluent;
  
  public MetadataConfig build() {
    MetadataConfig buildable = new MetadataConfig(fluent.getMaxSamplesPerSend(),fluent.getSend(),fluent.getSendInterval());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}