package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProbeSpecBuilder extends ProbeSpecFluent<ProbeSpecBuilder> implements VisitableBuilder<ProbeSpec,ProbeSpecBuilder>{
  public ProbeSpecBuilder() {
    this(new ProbeSpec());
  }
  
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent) {
    this(fluent, new ProbeSpec());
  }
  
  public ProbeSpecBuilder(ProbeSpecFluent<?> fluent,ProbeSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProbeSpecBuilder(ProbeSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProbeSpecFluent<?> fluent;
  
  public ProbeSpec build() {
    ProbeSpec buildable = new ProbeSpec(fluent.buildAuthorization(),fluent.buildBasicAuth(),fluent.getBearerTokenSecret(),fluent.getConvertClassicHistogramsToNHCB(),fluent.getFallbackScrapeProtocol(),fluent.getInterval(),fluent.getJobName(),fluent.getKeepDroppedTargets(),fluent.getLabelLimit(),fluent.getLabelNameLengthLimit(),fluent.getLabelValueLengthLimit(),fluent.buildMetricRelabelings(),fluent.getModule(),fluent.getNativeHistogramBucketLimit(),fluent.getNativeHistogramMinBucketFactor(),fluent.buildOauth2(),fluent.buildProber(),fluent.getSampleLimit(),fluent.getScrapeClass(),fluent.getScrapeClassicHistograms(),fluent.getScrapeProtocols(),fluent.getScrapeTimeout(),fluent.getTargetLimit(),fluent.buildTargets(),fluent.buildTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}