package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RetainConfigBuilder extends RetainConfigFluent<RetainConfigBuilder> implements VisitableBuilder<RetainConfig,RetainConfigBuilder>{
  public RetainConfigBuilder() {
    this(new RetainConfig());
  }
  
  public RetainConfigBuilder(RetainConfigFluent<?> fluent) {
    this(fluent, new RetainConfig());
  }
  
  public RetainConfigBuilder(RetainConfigFluent<?> fluent,RetainConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RetainConfigBuilder(RetainConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RetainConfigFluent<?> fluent;
  
  public RetainConfig build() {
    RetainConfig buildable = new RetainConfig(fluent.getRetentionPeriod());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}