package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ScrapeClassBuilder extends ScrapeClassFluent<ScrapeClassBuilder> implements VisitableBuilder<ScrapeClass,ScrapeClassBuilder>{
  public ScrapeClassBuilder() {
    this(new ScrapeClass());
  }
  
  public ScrapeClassBuilder(ScrapeClassFluent<?> fluent) {
    this(fluent, new ScrapeClass());
  }
  
  public ScrapeClassBuilder(ScrapeClassFluent<?> fluent,ScrapeClass instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ScrapeClassBuilder(ScrapeClass instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ScrapeClassFluent<?> fluent;
  
  public ScrapeClass build() {
    ScrapeClass buildable = new ScrapeClass(fluent.buildAttachMetadata(),fluent.buildAuthorization(),fluent.getDefault(),fluent.getFallbackScrapeProtocol(),fluent.buildMetricRelabelings(),fluent.getName(),fluent.buildRelabelings(),fluent.buildTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}