package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceMonitorSpecFluent<A extends ServiceMonitorSpecFluent<A>> extends BaseFluent<A>{
  public ServiceMonitorSpecFluent() {
  }
  
  public ServiceMonitorSpecFluent(ServiceMonitorSpec instance) {
    this.copyInstance(instance);
  }
  private AttachMetadataBuilder attachMetadata;
  private String bodySizeLimit;
  private Boolean convertClassicHistogramsToNHCB;
  private ArrayList<EndpointBuilder> endpoints = new ArrayList<EndpointBuilder>();
  private String fallbackScrapeProtocol;
  private String jobLabel;
  private Long keepDroppedTargets;
  private Long labelLimit;
  private Long labelNameLengthLimit;
  private Long labelValueLengthLimit;
  private NamespaceSelectorBuilder namespaceSelector;
  private Long nativeHistogramBucketLimit;
  private Quantity nativeHistogramMinBucketFactor;
  private List<String> podTargetLabels = new ArrayList<String>();
  private Long sampleLimit;
  private String scrapeClass;
  private Boolean scrapeClassicHistograms;
  private List<String> scrapeProtocols = new ArrayList<String>();
  private LabelSelectorBuilder selector;
  private String selectorMechanism;
  private List<String> targetLabels = new ArrayList<String>();
  private Long targetLimit;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServiceMonitorSpec instance) {
    instance = (instance != null ? instance : new ServiceMonitorSpec());
    if (instance != null) {
          this.withAttachMetadata(instance.getAttachMetadata());
          this.withBodySizeLimit(instance.getBodySizeLimit());
          this.withConvertClassicHistogramsToNHCB(instance.getConvertClassicHistogramsToNHCB());
          this.withEndpoints(instance.getEndpoints());
          this.withFallbackScrapeProtocol(instance.getFallbackScrapeProtocol());
          this.withJobLabel(instance.getJobLabel());
          this.withKeepDroppedTargets(instance.getKeepDroppedTargets());
          this.withLabelLimit(instance.getLabelLimit());
          this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
          this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withNativeHistogramBucketLimit(instance.getNativeHistogramBucketLimit());
          this.withNativeHistogramMinBucketFactor(instance.getNativeHistogramMinBucketFactor());
          this.withPodTargetLabels(instance.getPodTargetLabels());
          this.withSampleLimit(instance.getSampleLimit());
          this.withScrapeClass(instance.getScrapeClass());
          this.withScrapeClassicHistograms(instance.getScrapeClassicHistograms());
          this.withScrapeProtocols(instance.getScrapeProtocols());
          this.withSelector(instance.getSelector());
          this.withSelectorMechanism(instance.getSelectorMechanism());
          this.withTargetLabels(instance.getTargetLabels());
          this.withTargetLimit(instance.getTargetLimit());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AttachMetadata buildAttachMetadata() {
    return this.attachMetadata != null ? this.attachMetadata.build() : null;
  }
  
  public A withAttachMetadata(AttachMetadata attachMetadata) {
    this._visitables.remove("attachMetadata");
    if (attachMetadata != null) {
        this.attachMetadata = new AttachMetadataBuilder(attachMetadata);
        this._visitables.get("attachMetadata").add(this.attachMetadata);
    } else {
        this.attachMetadata = null;
        this._visitables.get("attachMetadata").remove(this.attachMetadata);
    }
    return (A) this;
  }
  
  public boolean hasAttachMetadata() {
    return this.attachMetadata != null;
  }
  
  public A withNewAttachMetadata(Boolean node) {
    return (A)withAttachMetadata(new AttachMetadata(node));
  }
  
  public AttachMetadataNested<A> withNewAttachMetadata() {
    return new AttachMetadataNested(null);
  }
  
  public AttachMetadataNested<A> withNewAttachMetadataLike(AttachMetadata item) {
    return new AttachMetadataNested(item);
  }
  
  public AttachMetadataNested<A> editAttachMetadata() {
    return withNewAttachMetadataLike(java.util.Optional.ofNullable(buildAttachMetadata()).orElse(null));
  }
  
  public AttachMetadataNested<A> editOrNewAttachMetadata() {
    return withNewAttachMetadataLike(java.util.Optional.ofNullable(buildAttachMetadata()).orElse(new AttachMetadataBuilder().build()));
  }
  
  public AttachMetadataNested<A> editOrNewAttachMetadataLike(AttachMetadata item) {
    return withNewAttachMetadataLike(java.util.Optional.ofNullable(buildAttachMetadata()).orElse(item));
  }
  
  public String getBodySizeLimit() {
    return this.bodySizeLimit;
  }
  
  public A withBodySizeLimit(String bodySizeLimit) {
    this.bodySizeLimit = bodySizeLimit;
    return (A) this;
  }
  
  public boolean hasBodySizeLimit() {
    return this.bodySizeLimit != null;
  }
  
  public Boolean getConvertClassicHistogramsToNHCB() {
    return this.convertClassicHistogramsToNHCB;
  }
  
  public A withConvertClassicHistogramsToNHCB(Boolean convertClassicHistogramsToNHCB) {
    this.convertClassicHistogramsToNHCB = convertClassicHistogramsToNHCB;
    return (A) this;
  }
  
  public boolean hasConvertClassicHistogramsToNHCB() {
    return this.convertClassicHistogramsToNHCB != null;
  }
  
  public A addToEndpoints(int index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);
    if (index < 0 || index >= endpoints.size()) {
        _visitables.get("endpoints").add(builder);
        endpoints.add(builder);
    } else {
        _visitables.get("endpoints").add(builder);
        endpoints.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToEndpoints(int index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);
    if (index < 0 || index >= endpoints.size()) {
        _visitables.get("endpoints").add(builder);
        endpoints.add(builder);
    } else {
        _visitables.get("endpoints").add(builder);
        endpoints.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  
  public A addAllToEndpoints(Collection<Endpoint> items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  
  public A removeFromEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... items) {
    if (this.endpoints == null) return (A)this;
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder); this.endpoints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEndpoints(Collection<Endpoint> items) {
    if (this.endpoints == null) return (A)this;
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder); this.endpoints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<EndpointBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      EndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Endpoint> buildEndpoints() {
    return this.endpoints != null ? build(endpoints) : null;
  }
  
  public Endpoint buildEndpoint(int index) {
    return this.endpoints.get(index).build();
  }
  
  public Endpoint buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  
  public Endpoint buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  
  public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
      for (EndpointBuilder item : endpoints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
      for (EndpointBuilder item : endpoints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEndpoints(List<Endpoint> endpoints) {
    if (this.endpoints != null) {
      this._visitables.get("endpoints").clear();
    }
    if (endpoints != null) {
        this.endpoints = new ArrayList();
        for (Endpoint item : endpoints) {
          this.addToEndpoints(item);
        }
    } else {
      this.endpoints = null;
    }
    return (A) this;
  }
  
  public A withEndpoints(io.fabric8.openshift.api.model.monitoring.v1.Endpoint... endpoints) {
    if (this.endpoints != null) {
        this.endpoints.clear();
        _visitables.remove("endpoints");
    }
    if (endpoints != null) {
      for (Endpoint item : endpoints) {
        this.addToEndpoints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEndpoints() {
    return this.endpoints != null && !this.endpoints.isEmpty();
  }
  
  public EndpointsNested<A> addNewEndpoint() {
    return new EndpointsNested(-1, null);
  }
  
  public EndpointsNested<A> addNewEndpointLike(Endpoint item) {
    return new EndpointsNested(-1, item);
  }
  
  public EndpointsNested<A> setNewEndpointLike(int index,Endpoint item) {
    return new EndpointsNested(index, item);
  }
  
  public EndpointsNested<A> editEndpoint(int index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  
  public EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public String getFallbackScrapeProtocol() {
    return this.fallbackScrapeProtocol;
  }
  
  public A withFallbackScrapeProtocol(String fallbackScrapeProtocol) {
    this.fallbackScrapeProtocol = fallbackScrapeProtocol;
    return (A) this;
  }
  
  public boolean hasFallbackScrapeProtocol() {
    return this.fallbackScrapeProtocol != null;
  }
  
  public String getJobLabel() {
    return this.jobLabel;
  }
  
  public A withJobLabel(String jobLabel) {
    this.jobLabel = jobLabel;
    return (A) this;
  }
  
  public boolean hasJobLabel() {
    return this.jobLabel != null;
  }
  
  public Long getKeepDroppedTargets() {
    return this.keepDroppedTargets;
  }
  
  public A withKeepDroppedTargets(Long keepDroppedTargets) {
    this.keepDroppedTargets = keepDroppedTargets;
    return (A) this;
  }
  
  public boolean hasKeepDroppedTargets() {
    return this.keepDroppedTargets != null;
  }
  
  public Long getLabelLimit() {
    return this.labelLimit;
  }
  
  public A withLabelLimit(Long labelLimit) {
    this.labelLimit = labelLimit;
    return (A) this;
  }
  
  public boolean hasLabelLimit() {
    return this.labelLimit != null;
  }
  
  public Long getLabelNameLengthLimit() {
    return this.labelNameLengthLimit;
  }
  
  public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
    this.labelNameLengthLimit = labelNameLengthLimit;
    return (A) this;
  }
  
  public boolean hasLabelNameLengthLimit() {
    return this.labelNameLengthLimit != null;
  }
  
  public Long getLabelValueLengthLimit() {
    return this.labelValueLengthLimit;
  }
  
  public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
    this.labelValueLengthLimit = labelValueLengthLimit;
    return (A) this;
  }
  
  public boolean hasLabelValueLengthLimit() {
    return this.labelValueLengthLimit != null;
  }
  
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
  }
  
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    this._visitables.remove("namespaceSelector");
    if (namespaceSelector != null) {
        this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
        this._visitables.get("namespaceSelector").add(this.namespaceSelector);
    } else {
        this.namespaceSelector = null;
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new NamespaceSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public Long getNativeHistogramBucketLimit() {
    return this.nativeHistogramBucketLimit;
  }
  
  public A withNativeHistogramBucketLimit(Long nativeHistogramBucketLimit) {
    this.nativeHistogramBucketLimit = nativeHistogramBucketLimit;
    return (A) this;
  }
  
  public boolean hasNativeHistogramBucketLimit() {
    return this.nativeHistogramBucketLimit != null;
  }
  
  public Quantity getNativeHistogramMinBucketFactor() {
    return this.nativeHistogramMinBucketFactor;
  }
  
  public A withNativeHistogramMinBucketFactor(Quantity nativeHistogramMinBucketFactor) {
    this.nativeHistogramMinBucketFactor = nativeHistogramMinBucketFactor;
    return (A) this;
  }
  
  public boolean hasNativeHistogramMinBucketFactor() {
    return this.nativeHistogramMinBucketFactor != null;
  }
  
  public A withNewNativeHistogramMinBucketFactor(String amount,String format) {
    return (A)withNativeHistogramMinBucketFactor(new Quantity(amount, format));
  }
  
  public A withNewNativeHistogramMinBucketFactor(String amount) {
    return (A)withNativeHistogramMinBucketFactor(new Quantity(amount));
  }
  
  public A addToPodTargetLabels(int index,String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    this.podTargetLabels.add(index, item);
    return (A)this;
  }
  
  public A setToPodTargetLabels(int index,String item) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    this.podTargetLabels.set(index, item); return (A)this;
  }
  
  public A addToPodTargetLabels(java.lang.String... items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  
  public A addAllToPodTargetLabels(Collection<String> items) {
    if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
    for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
  }
  
  public A removeFromPodTargetLabels(java.lang.String... items) {
    if (this.podTargetLabels == null) return (A)this;
    for (String item : items) { this.podTargetLabels.remove(item);} return (A)this;
  }
  
  public A removeAllFromPodTargetLabels(Collection<String> items) {
    if (this.podTargetLabels == null) return (A)this;
    for (String item : items) { this.podTargetLabels.remove(item);} return (A)this;
  }
  
  public List<String> getPodTargetLabels() {
    return this.podTargetLabels;
  }
  
  public String getPodTargetLabel(int index) {
    return this.podTargetLabels.get(index);
  }
  
  public String getFirstPodTargetLabel() {
    return this.podTargetLabels.get(0);
  }
  
  public String getLastPodTargetLabel() {
    return this.podTargetLabels.get(podTargetLabels.size() - 1);
  }
  
  public String getMatchingPodTargetLabel(Predicate<String> predicate) {
      for (String item : podTargetLabels) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
      for (String item : podTargetLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPodTargetLabels(List<String> podTargetLabels) {
    if (podTargetLabels != null) {
        this.podTargetLabels = new ArrayList();
        for (String item : podTargetLabels) {
          this.addToPodTargetLabels(item);
        }
    } else {
      this.podTargetLabels = null;
    }
    return (A) this;
  }
  
  public A withPodTargetLabels(java.lang.String... podTargetLabels) {
    if (this.podTargetLabels != null) {
        this.podTargetLabels.clear();
        _visitables.remove("podTargetLabels");
    }
    if (podTargetLabels != null) {
      for (String item : podTargetLabels) {
        this.addToPodTargetLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPodTargetLabels() {
    return this.podTargetLabels != null && !this.podTargetLabels.isEmpty();
  }
  
  public Long getSampleLimit() {
    return this.sampleLimit;
  }
  
  public A withSampleLimit(Long sampleLimit) {
    this.sampleLimit = sampleLimit;
    return (A) this;
  }
  
  public boolean hasSampleLimit() {
    return this.sampleLimit != null;
  }
  
  public String getScrapeClass() {
    return this.scrapeClass;
  }
  
  public A withScrapeClass(String scrapeClass) {
    this.scrapeClass = scrapeClass;
    return (A) this;
  }
  
  public boolean hasScrapeClass() {
    return this.scrapeClass != null;
  }
  
  public Boolean getScrapeClassicHistograms() {
    return this.scrapeClassicHistograms;
  }
  
  public A withScrapeClassicHistograms(Boolean scrapeClassicHistograms) {
    this.scrapeClassicHistograms = scrapeClassicHistograms;
    return (A) this;
  }
  
  public boolean hasScrapeClassicHistograms() {
    return this.scrapeClassicHistograms != null;
  }
  
  public A addToScrapeProtocols(int index,String item) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    this.scrapeProtocols.add(index, item);
    return (A)this;
  }
  
  public A setToScrapeProtocols(int index,String item) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    this.scrapeProtocols.set(index, item); return (A)this;
  }
  
  public A addToScrapeProtocols(java.lang.String... items) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    for (String item : items) {this.scrapeProtocols.add(item);} return (A)this;
  }
  
  public A addAllToScrapeProtocols(Collection<String> items) {
    if (this.scrapeProtocols == null) {this.scrapeProtocols = new ArrayList<String>();}
    for (String item : items) {this.scrapeProtocols.add(item);} return (A)this;
  }
  
  public A removeFromScrapeProtocols(java.lang.String... items) {
    if (this.scrapeProtocols == null) return (A)this;
    for (String item : items) { this.scrapeProtocols.remove(item);} return (A)this;
  }
  
  public A removeAllFromScrapeProtocols(Collection<String> items) {
    if (this.scrapeProtocols == null) return (A)this;
    for (String item : items) { this.scrapeProtocols.remove(item);} return (A)this;
  }
  
  public List<String> getScrapeProtocols() {
    return this.scrapeProtocols;
  }
  
  public String getScrapeProtocol(int index) {
    return this.scrapeProtocols.get(index);
  }
  
  public String getFirstScrapeProtocol() {
    return this.scrapeProtocols.get(0);
  }
  
  public String getLastScrapeProtocol() {
    return this.scrapeProtocols.get(scrapeProtocols.size() - 1);
  }
  
  public String getMatchingScrapeProtocol(Predicate<String> predicate) {
      for (String item : scrapeProtocols) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingScrapeProtocol(Predicate<String> predicate) {
      for (String item : scrapeProtocols) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withScrapeProtocols(List<String> scrapeProtocols) {
    if (scrapeProtocols != null) {
        this.scrapeProtocols = new ArrayList();
        for (String item : scrapeProtocols) {
          this.addToScrapeProtocols(item);
        }
    } else {
      this.scrapeProtocols = null;
    }
    return (A) this;
  }
  
  public A withScrapeProtocols(java.lang.String... scrapeProtocols) {
    if (this.scrapeProtocols != null) {
        this.scrapeProtocols.clear();
        _visitables.remove("scrapeProtocols");
    }
    if (scrapeProtocols != null) {
      for (String item : scrapeProtocols) {
        this.addToScrapeProtocols(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasScrapeProtocols() {
    return this.scrapeProtocols != null && !this.scrapeProtocols.isEmpty();
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getSelectorMechanism() {
    return this.selectorMechanism;
  }
  
  public A withSelectorMechanism(String selectorMechanism) {
    this.selectorMechanism = selectorMechanism;
    return (A) this;
  }
  
  public boolean hasSelectorMechanism() {
    return this.selectorMechanism != null;
  }
  
  public A addToTargetLabels(int index,String item) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    this.targetLabels.add(index, item);
    return (A)this;
  }
  
  public A setToTargetLabels(int index,String item) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    this.targetLabels.set(index, item); return (A)this;
  }
  
  public A addToTargetLabels(java.lang.String... items) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    for (String item : items) {this.targetLabels.add(item);} return (A)this;
  }
  
  public A addAllToTargetLabels(Collection<String> items) {
    if (this.targetLabels == null) {this.targetLabels = new ArrayList<String>();}
    for (String item : items) {this.targetLabels.add(item);} return (A)this;
  }
  
  public A removeFromTargetLabels(java.lang.String... items) {
    if (this.targetLabels == null) return (A)this;
    for (String item : items) { this.targetLabels.remove(item);} return (A)this;
  }
  
  public A removeAllFromTargetLabels(Collection<String> items) {
    if (this.targetLabels == null) return (A)this;
    for (String item : items) { this.targetLabels.remove(item);} return (A)this;
  }
  
  public List<String> getTargetLabels() {
    return this.targetLabels;
  }
  
  public String getTargetLabel(int index) {
    return this.targetLabels.get(index);
  }
  
  public String getFirstTargetLabel() {
    return this.targetLabels.get(0);
  }
  
  public String getLastTargetLabel() {
    return this.targetLabels.get(targetLabels.size() - 1);
  }
  
  public String getMatchingTargetLabel(Predicate<String> predicate) {
      for (String item : targetLabels) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTargetLabel(Predicate<String> predicate) {
      for (String item : targetLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTargetLabels(List<String> targetLabels) {
    if (targetLabels != null) {
        this.targetLabels = new ArrayList();
        for (String item : targetLabels) {
          this.addToTargetLabels(item);
        }
    } else {
      this.targetLabels = null;
    }
    return (A) this;
  }
  
  public A withTargetLabels(java.lang.String... targetLabels) {
    if (this.targetLabels != null) {
        this.targetLabels.clear();
        _visitables.remove("targetLabels");
    }
    if (targetLabels != null) {
      for (String item : targetLabels) {
        this.addToTargetLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTargetLabels() {
    return this.targetLabels != null && !this.targetLabels.isEmpty();
  }
  
  public Long getTargetLimit() {
    return this.targetLimit;
  }
  
  public A withTargetLimit(Long targetLimit) {
    this.targetLimit = targetLimit;
    return (A) this;
  }
  
  public boolean hasTargetLimit() {
    return this.targetLimit != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceMonitorSpecFluent that = (ServiceMonitorSpecFluent) o;
    if (!java.util.Objects.equals(attachMetadata, that.attachMetadata)) return false;
    if (!java.util.Objects.equals(bodySizeLimit, that.bodySizeLimit)) return false;
    if (!java.util.Objects.equals(convertClassicHistogramsToNHCB, that.convertClassicHistogramsToNHCB)) return false;
    if (!java.util.Objects.equals(endpoints, that.endpoints)) return false;
    if (!java.util.Objects.equals(fallbackScrapeProtocol, that.fallbackScrapeProtocol)) return false;
    if (!java.util.Objects.equals(jobLabel, that.jobLabel)) return false;
    if (!java.util.Objects.equals(keepDroppedTargets, that.keepDroppedTargets)) return false;
    if (!java.util.Objects.equals(labelLimit, that.labelLimit)) return false;
    if (!java.util.Objects.equals(labelNameLengthLimit, that.labelNameLengthLimit)) return false;
    if (!java.util.Objects.equals(labelValueLengthLimit, that.labelValueLengthLimit)) return false;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
    if (!java.util.Objects.equals(nativeHistogramBucketLimit, that.nativeHistogramBucketLimit)) return false;
    if (!java.util.Objects.equals(nativeHistogramMinBucketFactor, that.nativeHistogramMinBucketFactor)) return false;
    if (!java.util.Objects.equals(podTargetLabels, that.podTargetLabels)) return false;
    if (!java.util.Objects.equals(sampleLimit, that.sampleLimit)) return false;
    if (!java.util.Objects.equals(scrapeClass, that.scrapeClass)) return false;
    if (!java.util.Objects.equals(scrapeClassicHistograms, that.scrapeClassicHistograms)) return false;
    if (!java.util.Objects.equals(scrapeProtocols, that.scrapeProtocols)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(selectorMechanism, that.selectorMechanism)) return false;
    if (!java.util.Objects.equals(targetLabels, that.targetLabels)) return false;
    if (!java.util.Objects.equals(targetLimit, that.targetLimit)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(attachMetadata,  bodySizeLimit,  convertClassicHistogramsToNHCB,  endpoints,  fallbackScrapeProtocol,  jobLabel,  keepDroppedTargets,  labelLimit,  labelNameLengthLimit,  labelValueLengthLimit,  namespaceSelector,  nativeHistogramBucketLimit,  nativeHistogramMinBucketFactor,  podTargetLabels,  sampleLimit,  scrapeClass,  scrapeClassicHistograms,  scrapeProtocols,  selector,  selectorMechanism,  targetLabels,  targetLimit,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attachMetadata != null) { sb.append("attachMetadata:"); sb.append(attachMetadata + ","); }
    if (bodySizeLimit != null) { sb.append("bodySizeLimit:"); sb.append(bodySizeLimit + ","); }
    if (convertClassicHistogramsToNHCB != null) { sb.append("convertClassicHistogramsToNHCB:"); sb.append(convertClassicHistogramsToNHCB + ","); }
    if (endpoints != null && !endpoints.isEmpty()) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (fallbackScrapeProtocol != null) { sb.append("fallbackScrapeProtocol:"); sb.append(fallbackScrapeProtocol + ","); }
    if (jobLabel != null) { sb.append("jobLabel:"); sb.append(jobLabel + ","); }
    if (keepDroppedTargets != null) { sb.append("keepDroppedTargets:"); sb.append(keepDroppedTargets + ","); }
    if (labelLimit != null) { sb.append("labelLimit:"); sb.append(labelLimit + ","); }
    if (labelNameLengthLimit != null) { sb.append("labelNameLengthLimit:"); sb.append(labelNameLengthLimit + ","); }
    if (labelValueLengthLimit != null) { sb.append("labelValueLengthLimit:"); sb.append(labelValueLengthLimit + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (nativeHistogramBucketLimit != null) { sb.append("nativeHistogramBucketLimit:"); sb.append(nativeHistogramBucketLimit + ","); }
    if (nativeHistogramMinBucketFactor != null) { sb.append("nativeHistogramMinBucketFactor:"); sb.append(nativeHistogramMinBucketFactor + ","); }
    if (podTargetLabels != null && !podTargetLabels.isEmpty()) { sb.append("podTargetLabels:"); sb.append(podTargetLabels + ","); }
    if (sampleLimit != null) { sb.append("sampleLimit:"); sb.append(sampleLimit + ","); }
    if (scrapeClass != null) { sb.append("scrapeClass:"); sb.append(scrapeClass + ","); }
    if (scrapeClassicHistograms != null) { sb.append("scrapeClassicHistograms:"); sb.append(scrapeClassicHistograms + ","); }
    if (scrapeProtocols != null && !scrapeProtocols.isEmpty()) { sb.append("scrapeProtocols:"); sb.append(scrapeProtocols + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (selectorMechanism != null) { sb.append("selectorMechanism:"); sb.append(selectorMechanism + ","); }
    if (targetLabels != null && !targetLabels.isEmpty()) { sb.append("targetLabels:"); sb.append(targetLabels + ","); }
    if (targetLimit != null) { sb.append("targetLimit:"); sb.append(targetLimit + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withConvertClassicHistogramsToNHCB() {
    return withConvertClassicHistogramsToNHCB(true);
  }
  
  public A withScrapeClassicHistograms() {
    return withScrapeClassicHistograms(true);
  }
  public class AttachMetadataNested<N> extends AttachMetadataFluent<AttachMetadataNested<N>> implements Nested<N>{
    AttachMetadataNested(AttachMetadata item) {
      this.builder = new AttachMetadataBuilder(this, item);
    }
    AttachMetadataBuilder builder;
    
    public N and() {
      return (N) ServiceMonitorSpecFluent.this.withAttachMetadata(builder.build());
    }
    
    public N endAttachMetadata() {
      return and();
    }
    
  
  }
  public class EndpointsNested<N> extends EndpointFluent<EndpointsNested<N>> implements Nested<N>{
    EndpointsNested(int index,Endpoint item) {
      this.index = index;
      this.builder = new EndpointBuilder(this, item);
    }
    EndpointBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceMonitorSpecFluent.this.setToEndpoints(index,builder.build());
    }
    
    public N endEndpoint() {
      return and();
    }
    
  
  }
  public class NamespaceSelectorNested<N> extends NamespaceSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorBuilder builder;
    
    public N and() {
      return (N) ServiceMonitorSpecFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ServiceMonitorSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}