package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ShardRetentionPolicyFluent<A extends ShardRetentionPolicyFluent<A>> extends BaseFluent<A>{
  public ShardRetentionPolicyFluent() {
  }
  
  public ShardRetentionPolicyFluent(ShardRetentionPolicy instance) {
    this.copyInstance(instance);
  }
  private RetainConfigBuilder retain;
  private String whenScaled;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ShardRetentionPolicy instance) {
    instance = (instance != null ? instance : new ShardRetentionPolicy());
    if (instance != null) {
          this.withRetain(instance.getRetain());
          this.withWhenScaled(instance.getWhenScaled());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public RetainConfig buildRetain() {
    return this.retain != null ? this.retain.build() : null;
  }
  
  public A withRetain(RetainConfig retain) {
    this._visitables.remove("retain");
    if (retain != null) {
        this.retain = new RetainConfigBuilder(retain);
        this._visitables.get("retain").add(this.retain);
    } else {
        this.retain = null;
        this._visitables.get("retain").remove(this.retain);
    }
    return (A) this;
  }
  
  public boolean hasRetain() {
    return this.retain != null;
  }
  
  public A withNewRetain(String retentionPeriod) {
    return (A)withRetain(new RetainConfig(retentionPeriod));
  }
  
  public RetainNested<A> withNewRetain() {
    return new RetainNested(null);
  }
  
  public RetainNested<A> withNewRetainLike(RetainConfig item) {
    return new RetainNested(item);
  }
  
  public RetainNested<A> editRetain() {
    return withNewRetainLike(java.util.Optional.ofNullable(buildRetain()).orElse(null));
  }
  
  public RetainNested<A> editOrNewRetain() {
    return withNewRetainLike(java.util.Optional.ofNullable(buildRetain()).orElse(new RetainConfigBuilder().build()));
  }
  
  public RetainNested<A> editOrNewRetainLike(RetainConfig item) {
    return withNewRetainLike(java.util.Optional.ofNullable(buildRetain()).orElse(item));
  }
  
  public String getWhenScaled() {
    return this.whenScaled;
  }
  
  public A withWhenScaled(String whenScaled) {
    this.whenScaled = whenScaled;
    return (A) this;
  }
  
  public boolean hasWhenScaled() {
    return this.whenScaled != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ShardRetentionPolicyFluent that = (ShardRetentionPolicyFluent) o;
    if (!java.util.Objects.equals(retain, that.retain)) return false;
    if (!java.util.Objects.equals(whenScaled, that.whenScaled)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(retain,  whenScaled,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (retain != null) { sb.append("retain:"); sb.append(retain + ","); }
    if (whenScaled != null) { sb.append("whenScaled:"); sb.append(whenScaled + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RetainNested<N> extends RetainConfigFluent<RetainNested<N>> implements Nested<N>{
    RetainNested(RetainConfig item) {
      this.builder = new RetainConfigBuilder(this, item);
    }
    RetainConfigBuilder builder;
    
    public N and() {
      return (N) ShardRetentionPolicyFluent.this.withRetain(builder.build());
    }
    
    public N endRetain() {
      return and();
    }
    
  
  }

}