package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EC2SDConfigFluent<A extends EC2SDConfigFluent<A>> extends BaseFluent<A>{
  public EC2SDConfigFluent() {
  }
  
  public EC2SDConfigFluent(EC2SDConfig instance) {
    this.copyInstance(instance);
  }
  private SecretKeySelector accessKey;
  private Boolean enableHTTP2;
  private ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
  private Boolean followRedirects;
  private String noProxy;
  private Integer port;
  private Map<String,List<SecretKeySelector>> proxyConnectHeader;
  private Boolean proxyFromEnvironment;
  private String proxyUrl;
  private String refreshInterval;
  private String region;
  private String roleARN;
  private SecretKeySelector secretKey;
  private SafeTLSConfigBuilder tlsConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EC2SDConfig instance) {
    instance = (instance != null ? instance : new EC2SDConfig());
    if (instance != null) {
          this.withAccessKey(instance.getAccessKey());
          this.withEnableHTTP2(instance.getEnableHTTP2());
          this.withFilters(instance.getFilters());
          this.withFollowRedirects(instance.getFollowRedirects());
          this.withNoProxy(instance.getNoProxy());
          this.withPort(instance.getPort());
          this.withProxyConnectHeader(instance.getProxyConnectHeader());
          this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
          this.withProxyUrl(instance.getProxyUrl());
          this.withRefreshInterval(instance.getRefreshInterval());
          this.withRegion(instance.getRegion());
          this.withRoleARN(instance.getRoleARN());
          this.withSecretKey(instance.getSecretKey());
          this.withTlsConfig(instance.getTlsConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretKeySelector getAccessKey() {
    return this.accessKey;
  }
  
  public A withAccessKey(SecretKeySelector accessKey) {
    this.accessKey = accessKey;
    return (A) this;
  }
  
  public boolean hasAccessKey() {
    return this.accessKey != null;
  }
  
  public A withNewAccessKey(String key,String name,Boolean optional) {
    return (A)withAccessKey(new SecretKeySelector(key, name, optional));
  }
  
  public Boolean getEnableHTTP2() {
    return this.enableHTTP2;
  }
  
  public A withEnableHTTP2(Boolean enableHTTP2) {
    this.enableHTTP2 = enableHTTP2;
    return (A) this;
  }
  
  public boolean hasEnableHTTP2() {
    return this.enableHTTP2 != null;
  }
  
  public A addToFilters(int index,Filter item) {
    if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
    FilterBuilder builder = new FilterBuilder(item);
    if (index < 0 || index >= filters.size()) {
        _visitables.get("filters").add(builder);
        filters.add(builder);
    } else {
        _visitables.get("filters").add(builder);
        filters.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToFilters(int index,Filter item) {
    if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
    FilterBuilder builder = new FilterBuilder(item);
    if (index < 0 || index >= filters.size()) {
        _visitables.get("filters").add(builder);
        filters.add(builder);
    } else {
        _visitables.get("filters").add(builder);
        filters.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToFilters(io.fabric8.openshift.api.model.monitoring.v1alpha1.Filter... items) {
    if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
    for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A addAllToFilters(Collection<Filter> items) {
    if (this.filters == null) {this.filters = new ArrayList<FilterBuilder>();}
    for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A removeFromFilters(io.fabric8.openshift.api.model.monitoring.v1alpha1.Filter... items) {
    if (this.filters == null) return (A)this;
    for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFilters(Collection<Filter> items) {
    if (this.filters == null) return (A)this;
    for (Filter item : items) {FilterBuilder builder = new FilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFilters(Predicate<FilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<FilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      FilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Filter> buildFilters() {
    return this.filters != null ? build(filters) : null;
  }
  
  public Filter buildFilter(int index) {
    return this.filters.get(index).build();
  }
  
  public Filter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  
  public Filter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  
  public Filter buildMatchingFilter(Predicate<FilterBuilder> predicate) {
      for (FilterBuilder item : filters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFilter(Predicate<FilterBuilder> predicate) {
      for (FilterBuilder item : filters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFilters(List<Filter> filters) {
    if (this.filters != null) {
      this._visitables.get("filters").clear();
    }
    if (filters != null) {
        this.filters = new ArrayList();
        for (Filter item : filters) {
          this.addToFilters(item);
        }
    } else {
      this.filters = null;
    }
    return (A) this;
  }
  
  public A withFilters(io.fabric8.openshift.api.model.monitoring.v1alpha1.Filter... filters) {
    if (this.filters != null) {
        this.filters.clear();
        _visitables.remove("filters");
    }
    if (filters != null) {
      for (Filter item : filters) {
        this.addToFilters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFilters() {
    return this.filters != null && !this.filters.isEmpty();
  }
  
  public FiltersNested<A> addNewFilter() {
    return new FiltersNested(-1, null);
  }
  
  public FiltersNested<A> addNewFilterLike(Filter item) {
    return new FiltersNested(-1, item);
  }
  
  public FiltersNested<A> setNewFilterLike(int index,Filter item) {
    return new FiltersNested(index, item);
  }
  
  public FiltersNested<A> editFilter(int index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  
  public FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editMatchingFilter(Predicate<FilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public Boolean getFollowRedirects() {
    return this.followRedirects;
  }
  
  public A withFollowRedirects(Boolean followRedirects) {
    this.followRedirects = followRedirects;
    return (A) this;
  }
  
  public boolean hasFollowRedirects() {
    return this.followRedirects != null;
  }
  
  public String getNoProxy() {
    return this.noProxy;
  }
  
  public A withNoProxy(String noProxy) {
    this.noProxy = noProxy;
    return (A) this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public A addToProxyConnectHeader(String key,List<SecretKeySelector> value) {
    if(this.proxyConnectHeader == null && key != null && value != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(key != null && value != null) {this.proxyConnectHeader.put(key, value);} return (A)this;
  }
  
  public A addToProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null && map != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(map != null) { this.proxyConnectHeader.putAll(map);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(String key) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(key != null && this.proxyConnectHeader != null) {this.proxyConnectHeader.remove(key);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.proxyConnectHeader != null){this.proxyConnectHeader.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<SecretKeySelector>> getProxyConnectHeader() {
    return this.proxyConnectHeader;
  }
  
  public <K,V>A withProxyConnectHeader(Map<String,List<SecretKeySelector>> proxyConnectHeader) {
    if (proxyConnectHeader == null) {
      this.proxyConnectHeader = null;
    } else {
      this.proxyConnectHeader = new LinkedHashMap(proxyConnectHeader);
    }
    return (A) this;
  }
  
  public boolean hasProxyConnectHeader() {
    return this.proxyConnectHeader != null;
  }
  
  public Boolean getProxyFromEnvironment() {
    return this.proxyFromEnvironment;
  }
  
  public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
    this.proxyFromEnvironment = proxyFromEnvironment;
    return (A) this;
  }
  
  public boolean hasProxyFromEnvironment() {
    return this.proxyFromEnvironment != null;
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public String getRefreshInterval() {
    return this.refreshInterval;
  }
  
  public A withRefreshInterval(String refreshInterval) {
    this.refreshInterval = refreshInterval;
    return (A) this;
  }
  
  public boolean hasRefreshInterval() {
    return this.refreshInterval != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getRoleARN() {
    return this.roleARN;
  }
  
  public A withRoleARN(String roleARN) {
    this.roleARN = roleARN;
    return (A) this;
  }
  
  public boolean hasRoleARN() {
    return this.roleARN != null;
  }
  
  public SecretKeySelector getSecretKey() {
    return this.secretKey;
  }
  
  public A withSecretKey(SecretKeySelector secretKey) {
    this.secretKey = secretKey;
    return (A) this;
  }
  
  public boolean hasSecretKey() {
    return this.secretKey != null;
  }
  
  public A withNewSecretKey(String key,String name,Boolean optional) {
    return (A)withSecretKey(new SecretKeySelector(key, name, optional));
  }
  
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    this._visitables.remove("tlsConfig");
    if (tlsConfig != null) {
        this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EC2SDConfigFluent that = (EC2SDConfigFluent) o;
    if (!java.util.Objects.equals(accessKey, that.accessKey)) return false;
    if (!java.util.Objects.equals(enableHTTP2, that.enableHTTP2)) return false;
    if (!java.util.Objects.equals(filters, that.filters)) return false;
    if (!java.util.Objects.equals(followRedirects, that.followRedirects)) return false;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(proxyConnectHeader, that.proxyConnectHeader)) return false;
    if (!java.util.Objects.equals(proxyFromEnvironment, that.proxyFromEnvironment)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(refreshInterval, that.refreshInterval)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(roleARN, that.roleARN)) return false;
    if (!java.util.Objects.equals(secretKey, that.secretKey)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessKey,  enableHTTP2,  filters,  followRedirects,  noProxy,  port,  proxyConnectHeader,  proxyFromEnvironment,  proxyUrl,  refreshInterval,  region,  roleARN,  secretKey,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessKey != null) { sb.append("accessKey:"); sb.append(accessKey + ","); }
    if (enableHTTP2 != null) { sb.append("enableHTTP2:"); sb.append(enableHTTP2 + ","); }
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (followRedirects != null) { sb.append("followRedirects:"); sb.append(followRedirects + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (proxyConnectHeader != null && !proxyConnectHeader.isEmpty()) { sb.append("proxyConnectHeader:"); sb.append(proxyConnectHeader + ","); }
    if (proxyFromEnvironment != null) { sb.append("proxyFromEnvironment:"); sb.append(proxyFromEnvironment + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (refreshInterval != null) { sb.append("refreshInterval:"); sb.append(refreshInterval + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (roleARN != null) { sb.append("roleARN:"); sb.append(roleARN + ","); }
    if (secretKey != null) { sb.append("secretKey:"); sb.append(secretKey + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnableHTTP2() {
    return withEnableHTTP2(true);
  }
  
  public A withFollowRedirects() {
    return withFollowRedirects(true);
  }
  
  public A withProxyFromEnvironment() {
    return withProxyFromEnvironment(true);
  }
  public class FiltersNested<N> extends FilterFluent<FiltersNested<N>> implements Nested<N>{
    FiltersNested(int index,Filter item) {
      this.index = index;
      this.builder = new FilterBuilder(this, item);
    }
    FilterBuilder builder;
    int index;
    
    public N and() {
      return (N) EC2SDConfigFluent.this.setToFilters(index,builder.build());
    }
    
    public N endFilter() {
      return and();
    }
    
  
  }
  public class TlsConfigNested<N> extends SafeTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    SafeTLSConfigBuilder builder;
    
    public N and() {
      return (N) EC2SDConfigFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}